/*
 * Decompiled with CFR 0.152.
 */
package edu.hws.jcm.data;

import edu.hws.jcm.data.Cases;
import edu.hws.jcm.data.Constant;
import edu.hws.jcm.data.Expression;
import edu.hws.jcm.data.Function;
import edu.hws.jcm.data.Variable;

public class SimpleFunction
implements Function {
    private Expression e;
    private Variable[] v;
    private String name;
    private double[] save;

    public SimpleFunction(Expression expression, Variable variable) {
        this(expression, new Variable[]{variable});
    }

    public SimpleFunction(Expression expression, Variable[] variableArray) {
        this.e = expression;
        this.v = variableArray;
        this.save = new double[variableArray.length];
    }

    @Override
    public int getArity() {
        return this.v.length;
    }

    @Override
    public double getVal(double[] dArray) {
        return this.getValueWithCases(dArray, null);
    }

    @Override
    public double getValueWithCases(double[] dArray, Cases cases) {
        for (int i = 0; i < this.v.length; ++i) {
            this.save[i] = this.v[i].getVal();
            this.v[i].setVal(dArray[i]);
        }
        double d = this.e.getValueWithCases(cases);
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i].setVal(this.save[i]);
        }
        return d;
    }

    @Override
    public Function derivative(int n) {
        if (n < 1 || n > this.v.length) {
            throw new IllegalArgumentException("Internal Error.  Function does not have an argument number  " + n);
        }
        return new SimpleFunction(this.e.derivative(this.v[n - 1]), this.v);
    }

    @Override
    public Function derivative(Variable variable) {
        for (int i = 0; i < this.v.length; ++i) {
            if (variable != this.v[i]) continue;
            return new SimpleFunction((Expression)new Constant(0.0), this.v);
        }
        return new SimpleFunction(this.e.derivative(variable), this.v);
    }

    @Override
    public boolean dependsOn(Variable variable) {
        for (int i = 0; i < this.v.length; ++i) {
            if (variable != this.v[i]) continue;
            return false;
        }
        return this.e.dependsOn(variable);
    }
}

