/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.TextPosition;
import adql.query.constraint.ADQLConstraint;
import java.util.NoSuchElementException;

public class NotConstraint
implements ADQLConstraint {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "NOT", false, "A NOT constraint (which tests whether a boolean expression is not true).");
    private ADQLConstraint constraint;
    private TextPosition position = null;

    public NotConstraint(ADQLConstraint constraint) throws NullPointerException {
        if (constraint == null) {
            throw new NullPointerException("Impossible to apply the logical operator NOT on a NULL constraint!");
        }
        this.constraint = constraint;
    }

    public final ADQLConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    public final void setPosition(TextPosition position) {
        this.position = position;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new NotConstraint((ADQLConstraint)this.constraint.getCopy());
    }

    @Override
    public String getName() {
        return "NOT " + this.constraint.getName();
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean constraintGot;
            {
                this.constraintGot = NotConstraint.this.constraint == null;
            }

            @Override
            public ADQLObject next() {
                if (this.constraintGot) {
                    throw new NoSuchElementException();
                }
                this.constraintGot = true;
                return NotConstraint.this.constraint;
            }

            @Override
            public boolean hasNext() {
                return !this.constraintGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.constraintGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                } else if (replacer instanceof ADQLConstraint) {
                    NotConstraint.this.constraint = (ADQLConstraint)replacer;
                    NotConstraint.this.position = null;
                } else {
                    throw new UnsupportedOperationException("Impossible to replace an ADQLConstraint by a " + replacer.getClass().getName() + "!");
                }
            }

            @Override
            public void remove() {
                if (!this.constraintGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the constraint of a NOT predicated!");
            }
        };
    }

    @Override
    public String toADQL() {
        return "NOT " + this.constraint.toADQL();
    }
}

