/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.DBTable;
import adql.query.IdentifierField;
import adql.query.from.ADQLJoin;
import adql.query.operand.ADQLColumn;
import cds.utils.TextualSearchList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class SearchColumnList
extends TextualSearchList<DBColumn> {
    private static final long serialVersionUID = 1L;
    private boolean distinct = false;
    private final Map<String, String> tableAliases = new HashMap<String, String>();
    private final Map<String, List<String>> mapAliases = new HashMap<String, List<String>>();

    public SearchColumnList() {
        super(new DBColumnKeyExtractor());
    }

    public SearchColumnList(Collection<DBColumn> collection) {
        super(collection, new DBColumnKeyExtractor());
    }

    public SearchColumnList(int initialCapacity) {
        super(initialCapacity, new DBColumnKeyExtractor());
    }

    public final boolean isDistinct() {
        return this.distinct;
    }

    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public final void putTableAlias(String tableAlias, String tableName) {
        if (tableAlias != null && tableName != null) {
            this.tableAliases.put(tableAlias, tableName);
            List<String> aliases = this.mapAliases.get(tableAlias.toLowerCase());
            if (aliases == null) {
                aliases = new ArrayList<String>();
                this.mapAliases.put(tableAlias.toLowerCase(), aliases);
            }
            aliases.add(tableAlias);
        }
    }

    public final void removeTableAlias(String tableAlias) {
        this.tableAliases.remove(tableAlias);
        List<String> aliases = this.mapAliases.get(tableAlias.toLowerCase());
        if (aliases != null) {
            aliases.remove(tableAlias);
            if (aliases.isEmpty()) {
                this.mapAliases.remove(tableAlias.toLowerCase());
            }
        }
    }

    public final void removeAllTableAliases() {
        this.tableAliases.clear();
        this.mapAliases.clear();
    }

    public final int getNbTableAliases() {
        return this.tableAliases.size();
    }

    public List<DBColumn> search(String columnName) {
        return this.get(columnName);
    }

    public final List<DBColumn> search(String catalog, String schema, String table, String column) {
        return this.search(catalog, schema, table, column, (byte)0);
    }

    public List<DBColumn> search(ADQLColumn column) {
        return this.search(column.getCatalogName(), column.getSchemaName(), column.getTableName(), column.getColumnName(), column.getCaseSensitive());
    }

    public List<DBColumn> search(String catalog, String schema, String table, String column, byte caseSensitivity) {
        List<DBColumn> tmpResult = this.get(column, IdentifierField.COLUMN.isCaseSensitive(caseSensitivity));
        if (table != null) {
            String tableName = null;
            List<String> aliasMatches = null;
            if (IdentifierField.TABLE.isCaseSensitive(caseSensitivity)) {
                tableName = this.tableAliases.get(table);
                if (tableName == null) {
                    tableName = table;
                }
            } else {
                aliasMatches = this.mapAliases.get(table.toLowerCase());
                if (aliasMatches == null || aliasMatches.isEmpty()) {
                    tableName = table;
                }
            }
            ArrayList<DBColumn> result = new ArrayList<DBColumn>();
            for (DBColumn match : tmpResult) {
                Iterator<DBTable> itMatchTables = ADQLJoin.isCommonColumn(match) ? ((DBCommonColumn)match).getCoveredTables() : new SingleIterator<DBTable>(match.getTable());
                while (itMatchTables.hasNext()) {
                    DBTable matchTable = itMatchTables.next();
                    if (aliasMatches == null) {
                        if (IdentifierField.TABLE.isCaseSensitive(caseSensitivity) ? !matchTable.getADQLName().equals(tableName) : !matchTable.getADQLName().equalsIgnoreCase(tableName)) {
                            continue;
                        }
                    } else {
                        boolean foundAlias = false;
                        for (int a = 0; !foundAlias && a < aliasMatches.size(); ++a) {
                            String temp = this.tableAliases.get(aliasMatches.get(a));
                            if (temp == null) continue;
                            foundAlias = matchTable.getADQLName().equalsIgnoreCase(temp);
                        }
                        if (!foundAlias) continue;
                    }
                    if (schema != null && (matchTable.getADQLSchemaName() == null || (!IdentifierField.SCHEMA.isCaseSensitive(caseSensitivity) ? !matchTable.getADQLSchemaName().equalsIgnoreCase(schema) : !matchTable.getADQLSchemaName().equals(schema)) || catalog != null && (matchTable.getADQLCatalogName() == null || (IdentifierField.CATALOG.isCaseSensitive(caseSensitivity) ? !matchTable.getADQLCatalogName().equals(catalog) : !matchTable.getADQLCatalogName().equalsIgnoreCase(catalog))))) continue;
                    DBColumn goodMatch = matchTable.getColumn(match.getADQLName(), true);
                    result.add(goodMatch);
                }
            }
            return result;
        }
        if (tmpResult.size() > 1) {
            ArrayList<DBColumn> result = new ArrayList<DBColumn>(tmpResult.size());
            for (int i = 0; i < tmpResult.size(); ++i) {
                if (!ADQLJoin.isCommonColumn(tmpResult.get(i))) continue;
                DBCommonColumn commonColumn = (DBCommonColumn)tmpResult.remove(i);
                result.add(commonColumn);
                Iterator<DBTable> itCoveredTables = commonColumn.getCoveredTables();
                while (itCoveredTables.hasNext()) {
                    tmpResult.add(itCoveredTables.next().getColumn(column, true));
                }
            }
            if (result.size() == 1) {
                return result;
            }
        }
        return tmpResult;
    }

    @Override
    public boolean add(DBColumn item) {
        if (this.distinct && this.contains(item)) {
            return false;
        }
        return super.add(item);
    }

    @Override
    public boolean addAll(Collection<? extends DBColumn> c) {
        boolean changed = super.addAll(c);
        if (changed && c instanceof SearchColumnList) {
            SearchColumnList list = (SearchColumnList)c;
            for (Map.Entry<String, String> entry : list.tableAliases.entrySet()) {
                this.putTableAlias(entry.getKey(), entry.getValue());
            }
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = super.removeAll(c);
        if (changed && c instanceof SearchColumnList) {
            SearchColumnList list = (SearchColumnList)c;
            for (String key : list.tableAliases.keySet()) {
                this.removeTableAlias(key);
            }
        }
        return changed;
    }

    private static class SingleIterator<E>
    implements Iterator<E> {
        private final E item;
        private boolean done = false;

        public SingleIterator(E singleItem) {
            this.item = singleItem;
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public E next() {
            if (!this.done) {
                this.done = true;
                return this.item;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DBColumnKeyExtractor
    implements TextualSearchList.KeyExtractor<DBColumn> {
        private DBColumnKeyExtractor() {
        }

        @Override
        public String getKey(DBColumn obj) {
            if (obj.isCaseSensitive()) {
                return obj.getADQLName();
            }
            return obj.getADQLName().toLowerCase();
        }
    }
}

