/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.Healpix;
import java.util.Iterator;

abstract class AbstractHealpixNestedMOC<E extends CurrentCellAccessor>
implements Iterable<E> {
    protected final int depthMax;
    protected final long[] cells;
    protected final int to;

    protected AbstractHealpixNestedMOC(int mocDepth, long[] mocCells) {
        this(mocDepth, mocCells, mocCells.length);
    }

    protected AbstractHealpixNestedMOC(int mocDepth, long[] mocCells, int toIndex) {
        AbstractHealpixNestedMOC.checkDepth(mocDepth);
        this.depthMax = mocDepth;
        this.cells = mocCells;
        this.to = toIndex;
    }

    protected static final void checkDepth(int depth) {
        if (depth >= 29) {
            throw new IllegalArgumentException("Depth larger than or equal to 29 not uspported.");
        }
    }

    protected static long rmSentinel(long mocEncodedHash) {
        return AbstractHealpixNestedMOC.turnOffRightmost1Bit(mocEncodedHash);
    }

    protected static long getHash(long mocEncodedHash, int depthMax) {
        return AbstractHealpixNestedMOC.getHashFromDepth(mocEncodedHash, AbstractHealpixNestedMOC.getDepth(mocEncodedHash, depthMax));
    }

    protected static long getHashFromDepth(long mocEncodedHash, int depth) {
        return mocEncodedHash >>> 1 + (depth << 1);
    }

    protected static int getDepth(long mocEncodedHash, int depthMax) {
        return depthMax - (Long.numberOfTrailingZeros(mocEncodedHash) >> 1);
    }

    protected static final boolean aIsALargerCellThanB(long mocEncodedHashA, long mocEncodedHashB) {
        return AbstractHealpixNestedMOC.aHasSmallerDepthThanB(mocEncodedHashA, mocEncodedHashB);
    }

    protected static final boolean aHasSmallerDepthThanB(long mocEncodedHashA, long mocEncodedHashB) {
        return AbstractHealpixNestedMOC.isolateRightmost1Bit(mocEncodedHashA) < AbstractHealpixNestedMOC.isolateRightmost1Bit(mocEncodedHashB);
    }

    protected static final long turnOffRightmost1Bit(long x) {
        return x & x - 1L;
    }

    protected static final long isolateRightmost1Bit(long x) {
        return x & -x;
    }

    public static final long encodeHash4MOC(int depth, long hash, int depthMax) {
        hash <<= 1;
        hash |= 1L;
        return hash <<= 1 + (depthMax - depth << 1);
    }

    protected static final boolean contains(long largerCellMocEncodedHashNoSentinel, long smallerCellMocEncodedHashNoSentinek) {
        return (largerCellMocEncodedHashNoSentinel & smallerCellMocEncodedHashNoSentinek) == largerCellMocEncodedHashNoSentinel;
    }

    protected static void checkIsSortedNoDuplicateNoOverlap(long[] mocCells) {
        if (mocCells.length > 0) {
            long prev = mocCells[0];
            long prevNoSentinel = AbstractHealpixNestedMOC.rmSentinel(prev);
            for (int i = 1; i < mocCells.length; ++i) {
                long curr = mocCells[i];
                long currNoSentinel = AbstractHealpixNestedMOC.rmSentinel(curr);
                if (prev >= curr) {
                    throw new IllegalArgumentException("Not valid MOC: not sorted");
                }
                long aAndB = prevNoSentinel & currNoSentinel;
                if (aAndB == prevNoSentinel || aAndB == currNoSentinel) {
                    throw new IllegalArgumentException("Not valid MOC: elem " + curr + " overlap with " + prev);
                }
                prev = curr;
                prevNoSentinel = currNoSentinel;
            }
        }
    }

    public final int getDepthMax() {
        return this.depthMax;
    }

    public final int size() {
        return this.to;
    }

    public final long computeDeepSize() {
        long tot = 0L;
        for (int i = 0; i < this.to; ++i) {
            int depth = AbstractHealpixNestedMOC.getDepth(this.cells[i], this.depthMax);
            tot += Healpix.nsideSquare(depth);
        }
        return tot;
    }

    protected abstract class Iter
    implements Iterator<E>,
    CurrentCellAccessor {
        private int i = 0;
        private long h = -1L;
        private int d = 0;

        protected Iter() {
        }

        protected abstract E returnThis();

        protected abstract void calledInNext(int var1);

        @Override
        public final long getMOCEncodedHash() {
            return this.h;
        }

        @Override
        public final int getDepth() {
            return AbstractHealpixNestedMOC.this.depthMax - this.d;
        }

        @Override
        public final long getHash() {
            return this.h >> 1 + (this.d << 1);
        }

        @Override
        public final boolean hasNext() {
            return this.i < AbstractHealpixNestedMOC.this.to;
        }

        @Override
        public final E next() {
            this.h = AbstractHealpixNestedMOC.this.cells[this.i];
            this.d = Long.numberOfTrailingZeros(this.h) >> 1;
            this.calledInNext(this.i);
            ++this.i;
            return this.returnThis();
        }

        public String toString() {
            return String.format("d: %d; h: %d; raw: %d", this.getDepth(), this.getHash(), this.getMOCEncodedHash());
        }
    }

    public static interface CurrentCellAccessor {
        public long getMOCEncodedHash();

        public int getDepth();

        public long getHash();
    }
}

