# Community & related software

_Unofficial but related work on Shaarli. If you maintain one of these,
please get in touch with us to help us find a way to adapt your work to our fork._


## Related software

### REST API clients
See [REST API](REST-API.md) for a list of official and community clients.


### Third party plugins

- [autosave](https://github.com/kalvn/shaarli-plugin-autosave) by [@kalvn](https://github.com/kalvn): Automatically saves data when editing a Shaare to avoid any loss in case of crash or unexpected shutdown.
- [clickat](https://forge.tourmentine.com/n/shaarli-plugin-clickat) by [@n](https://forge.tourmentine.com/n): Makes Twitter and Fediverse addresses clickable.
- [code-coloration](https://github.com/ArthurHoaro/code-coloration) by [@ArthurHoaro](https://github.com/ArthurHoaro): client side code syntax highlighter.
- [custom-css](https://github.com/immanuelfodor/shaarli-custom-css) by [@immanuelfodor](https://github.com/immanuelfodor) - Customize the look and feel of the UI with custom CSS rules
- [disqus](https://github.com/kalvn/shaarli-plugin-disqus) by [@kalvn](https://github.com/kalvn): Adds Disqus comment system to your Shaarli.
- [emojione](https://github.com/immanuelfodor/emojione) by [@immanuelfodor](https://github.com/immanuelfodor) - Resurrected fork of the original emojione project
- [favicons](https://github.com/trailjeep/shaarli-favicons) by [@trailjeep](https://github.com/trailjeep) - Shaarli plugin to add favicon/filetype icons to Shaares.
- [google analytics](https://github.com/ericjuden/Shaarli-Google-Analytics-Plugin) by [@ericjuden](https://github.com/ericjuden): Adds Google Analytics tracking support
- [launch](https://github.com/ArthurHoaro/launch-plugin) - Launch Plugin is a plugin designed to enhance and customize Launch Theme for Shaarli.
- [markdown-toolbar](https://github.com/immanuelfodor/shaarli-markdown-toolbar) by [@immanuelfodor](https://github.com/immanuelfodor) - Easily insert markdown syntax into the Description field when editing a Shaare.
- [related](https://github.com/ilesinge/shaarli-related) by [@ilesinge](https://github.com/ilesinge) - Show related Shaares based on the number of identical tags.
- [shaargem](https://forge.tourmentine.com/n/shaarli-plugin-shaargem) by [@n](https://forge.tourmentine.com/n): Allow to shaare gemini capsules.
- [shaarli-descriptor](https://github.com/immanuelfodor/shaarli-descriptor) by [@immanuelfodor](https://github.com/immanuelfodor) - Customize the default height/number of rows of the Description field when editing a Shaare.
- [shaarli2mastodon](https://github.com/kalvn/shaarli2mastodon) by [@kalvn](https://github.com/kalvn) - This Shaarli plugin allows you to automatically publish links you post on your Mastodon timeline.
- [shaarli2twitter](https://github.com/ArthurHoaro/shaarli2twitter) by [@ArthurHoaro](https://github.com/ArthurHoaro) - Automatically tweet your Shaares from Shaarli
- [social](https://github.com/alexisju/social) by [@alexisju](https://github.com/alexisju): share links to social networks.
- [urlextern](https://github.com/trailjeep/shaarli-urlextern) by [@trailjeep](https://github.com/trailjeep) - Shaarli plugin to open external links in a new tab/window.
- [webhooks](https://gitlab.com/flow.gunso/shaarli-webhooks) by [@flow.gunso](https://gitlab.com/flow.gunso) - Shaarli plugin that enables user-defined callback URL, i.e. webhooks, for specific Shaarli events (link saving, deletion...)


### Themes

- [kalvn/Shaarli-Material](https://github.com/kalvn/Shaarli-Material) - A theme (template) based on Google's Material Design for Shaarli, the superfast delicious clone
- [ManufacturaInd/shaarli-2004licious-theme](https://github.com/ManufacturaInd/shaarli-2004licious-theme) - A template/theme as a humble homage to the early looks of the del.icio.us site
- [RolandTi/shaarli-stack](https://github.com/RolandTi/shaarli-stack) - A miminalist template/theme for Shaarli
- [xfnw/shaarli-default-dark](https://github.com/xfnw/shaarli-default-dark) - The default theme but nice and dark for your eyeballs
- [mrjovanovic/serious-theme-shaarli](https://github.com/mrjovanovic/serious-theme-shaarli) - A serious theme for Shaarli (custom CSS)


### Integration with other platforms

- [tt-rss-shaarli](https://github.com/jcsaaddupuy/tt-rss-shaarli) - [Tiny-Tiny RSS](https://tt-rss.org/) plugin that adds support for sharing articles with Shaarli
- [octopress-shaarli](https://github.com/ahmet2mir/octopress-shaarli) - Octopress plugin to retrieve Shaarli Shaares on the sidebar
- [Scuttle to Shaarli](https://github.com/q2apro/scuttle-to-shaarli) - Import bookmarks from Scuttle
- [Shaarli app for Cloudron](https://www.cloudron.io/button.html?app=com.github.shaarli) - [![](https://img.shields.io/badge/Cloudron-03A9F4?logo=Buffer)](https://www.cloudron.io/button.html?app=com.github.shaarli) Effortlessly run Shaarli with the help of [Cloudron](https://www.cloudron.io/)
- [Shaarli_ynh](https://github.com/YunoHost-Apps/shaarli_ynh) - [![](https://img.shields.io/badge/YunoHost-black?logo=Buffer)](https://install-app.yunohost.org/?app=shaarli) Shaarli is available as a [Yunohost](https://yunohost.org) app
- [shaarli_poster](https://github.com/getpelican/pelican-plugins/tree/master/shaarli_poster) - [pelican](https://getpelican.com) static blog generator plugin to auto-post articles on a Shaarli instance
- [shaarli .deb package](https://packages.debian.org/search?keywords=shaarli) - for [Debian](https://www.debian.org/) and [Freedombox](https://www.freedombox.org/)


### Mobile apps

- [ShaarliOS](https://github.com/mro/ShaarliOS) - [![](https://img.shields.io/badge/App%20Store-black?logo=apple)](https://apps.apple.com/app/shaarlios/id1027441388) Apple iOS share extension.
- [Shaarlier for Android](https://github.com/dimtion/Shaarlier) - [![](https://img.shields.io/badge/Play%20Store-3EB7C0?logo=Google%20Play)](https://play.google.com/store/apps/details?id=com.dimtion.shaarlier) Android application to simply add Shaares directly into your Shaarli via Sharing. Free software.
- [Stakali for Android](https://stakali.toneiv.eu) - [![](https://img.shields.io/badge/Play%20Store-3EB7C0?logo=Google%20Play)](https://play.google.com/store/apps/details?id=eu.toneiv.stakali) Stakali is a personal bookmark manager which synchronizes with Shaarli. Support offline work without instance, sync, browsing within app. Free use of up to 20 results.
- [Shaarli for Android](https://sebsauvage.net/links/?ZAyDzg) - Android application that adds Shaarli as a sharing provider.


### Desktop apps

- [Ulauncher Extension](https://github.com/sebw/ulauncher-shaarli) - Ulauncher is an an application launcher for Linux, this extension allows research in your Shaarli


### Browser extensions

- [Shaarli Firefox Extension](https://github.com/ikipatang/shaarli-web-extension) - [![](https://img.shields.io/badge/Firefox%20Add--ons-414141?logo=Firefox)](https://addons.mozilla.org/en-US/firefox/addon/shaarli/) toolbar button to share your current tab with Shaarli.
- [Add to Shaarli](https://github.com/burgyl/AddToShaarli) - [![](https://img.shields.io/badge/Chrome%20Web%20Store-white?logo=Google%20Chrome)](https://chrome.google.com/webstore/detail/add-to-shaarli/jhfblapoehcfajokolimghdfmeeakbee) lets you add the current tab or a note to your Shaarli instance.
- [WebLinks Ext](https://chrome.google.com/webstore/detail/weblinks-ext/pnejcofgljlklmmjkocipnanfdbaclke) - [![](https://img.shields.io/badge/Chrome%20Web%20Store-white?logo=Google%20Chrome)](https://chrome.google.com/webstore/detail/weblinks-ext/pnejcofgljlklmmjkocipnanfdbaclke) Save, edit and use your Shaarli. Support work offline, sync, trash, etc. Free software.
- [Shaarli Chrome Extension](https://github.com/octplane/Shiny-Shaarli) - toolbar button to share your current tab with Shaarli. (Removed from Chrome web store).


### Server apps

- [Shaarli Archiver](https://github.com/sebw/shaarli-archiver) - Shaarli and SingleFile to archive your bookmarks
- [shaarchiver](https://github.com/nodiscc/shaarchiver) - Archive your Shaarli bookmarks and their content
- [shaarli-river](https://github.com/mknexen/shaarli-river) - An aggregator for shaarlis with many features
- [Shaarlo](https://github.com/DMeloni/shaarlo) - An aggregator for shaarlis with many features
- [Shaarlimages](https://github.com/BoboTiG/shaarlimages) - An image-oriented aggregator for Shaarlis
- [mknexen/shaarli-api](https://github.com/mknexen/shaarli-api) - A REST API for Shaarli
- [Self dead link](https://framagit.org/qwertygc/shaarli-dev-code/blob/master/self-dead-link.php) - Detect dead links on shaarli. This version use the database of shaarli. [Another version](https://framagit.org/qwertygc/shaarli-dev-code/blob/master/dead-link.php), can be used for other shaarli instances (but is more resource consuming).
- [Bookmark Archiver](https://github.com/ArchiveBox/ArchiveBox) - Save an archived copy of all websites starred using browser bookmarks/Shaarli/Delicious/Instapaper/Unmark.it/Pocket/Pinboard. Outputs browseable html.


## Alternatives to Shaarli

See [awesome-selfhosted: bookmarks & link sharing](https://awesome-selfhosted.net/tags/bookmarks-and-link-sharing.html).


## Community

- [Liens en vrac de sebsauvage](https://sebsauvage.net/links/) - the original Shaarli
- [A large list of Shaarlis](http://porneia.free.fr/pub/links/ou-est-shaarli.html)
- [A list of working Shaarli aggregators](https://raw.githubusercontent.com/Oros42/find_shaarlis/master/annuaires.json)
- [A list of some known Shaarlis](https://github.com/Oros42/shaarlis_list)
- [Adieu Delicious, Diigo et StumbleUpon. Salut Shaarli ! - sebsauvage.net](https://sebsauvage.net/rhaa/index.php?2011/09/16/09/29/58-adieu-delicious-diigo-et-stumbleupon-salut-shaarli-) (fr) _16/09/2011 - the original post about Shaarli_
- [Original ideas/fixme/TODO page](https://sebsauvage.net/wiki/doku.php?id=php:shaarli:ideas)
- [Original discussion page](https://sebsauvage.net/wiki/doku.php?id=php:shaarli:discussion) (fr)
- [Original revisions history](https://sebsauvage.net/wiki/doku.php?id=php:shaarli:history)


### Articles and social media discussions
- 2020-04-05 - Hacker News - [Self-hosted instance of Shaarli - it is simple, fast and reliable](https://news.ycombinator.com/item?id=22780219)
- 2016-10-10 - Framasoft - [MyFrama : vos favoris partout, avec vous, rien qu’à vous !](https://framablog.org/2016/10/10/myframa-vos-favoris-et-framasofteries-partout-avec-vous-rien-qua-vous/)
- 2016-09-22 - Hacker News - [Shaarli – Personal, minimalist, database-free, bookmarking service (github.com)](https://news.ycombinator.com/item?id=12552176)
- 2015-08-15 - Reddit - [Question about migrating from WordPress to Shaarli.](https://www.reddit.com/r/selfhosted/comments/3h3zwh/question_about_migrating_from_wordpress_to_shaarli/)
- 2015-06-22 - Hacker News - [Shaarli: Self-hosted del.icio.us alternative (sebsauvage.net)](https://news.ycombinator.com/item?id=9755366)
- 2015-05-12 - Reddit - [shaarli - Self hosted Bookmarking / Delicious (PHP, MySQL)](https://www.reddit.com/r/selfhosted/comments/35pkkc/shaarli_self_hosted_bookmarking_delicious_php/)
- 2014-10-15 - OpenSource.com - [Five open source alternatives to popular web apps](https://opensource.com/life/14/10/five-open-source-alternatives-popular-web-apps)

It also appears in the following recommendation lists:
- [AlternativeTo](https://alternativeto.net/software/shaarli/)
- [FramaLibre](https://framalibre.org/content/shaarli)
- [Awesome-Selfhosted - Bookmarks and Link Sharing](https://awesome-selfhosted.net/tags/bookmarks-and-link-sharing.html)
