# Kubernetes

This tutorial uses [Helm](https://helm.sh/docs/intro/quickstart/) to install
Scaphandre, Prometheus and Grafana.

## Install Scaphandre

First we install Scaphandre which runs as a daemon set which creates a pod on
each node for collecting the metrics. The helm chart is not in a repo, it needs
to be installed from the source code.

    git clone https://github.com/hubblo-org/scaphandre
    cd scaphandre
    helm install scaphandre helm/scaphandre
### Parameters
#### Service monitor parameters

| Name                                       | Description                                                                                                     | Value                     |
| ------------------------------------------ | --------------------------------------------------------------------------------------------------------------- | ------------------------- |
| `serviceMonitor.enabled`           | Create ServiceMonitor Resource for scraping metrics using PrometheusOperator                                    | `false`                    |
| `serviceMonitor.namespace`         | The namespace in which the ServiceMonitor will be created   (if not set, default to namespace on which this chart is installed)                                                    | `""`                      |
| `serviceMonitor.interval`          | The interval at which metrics should be scraped                                                                 | `1m`                     |

## Install Prometheus

Next we will install Prometheus which will scrape the metrics generated by Scaphandre.

    helm repo add prometheus-community https://prometheus-community.github.io/helm-charts
    helm repo add kube-state-metrics https://kubernetes.github.io/kube-state-metrics
    helm repo update

    helm install prometheus prometheus-community/prometheus \
    --set alertmanager.persistentVolume.enabled=false \
    --set server.persistentVolume.enabled=false

This setup should only be used for testing as the Prometheus data is not
persisted if the pods are deleted.

You can access the Prometheus web UI by creating a port forwarding connection.

    kubectl port-forward deploy/prometheus-server 9090:9090

## Install Grafana

Create a configmap to store the Grafana dashboard.

    kubectl create configmap scaphandre-dashboard \
        --from-file=scaphandre-dashboard.json=docs_src/tutorials/grafana-kubernetes-dashboard.json

Install Grafana.

    helm repo add grafana https://grafana.github.io/helm-charts
    helm repo update

    helm install grafana grafana/grafana --values docs_src/tutorials/grafana-helm-values.yaml

Get the Grafana web UI password which is randomly generated.

    kubectl get secret grafana -o jsonpath="{.data.admin-password}" | base64 --decode

Create a port forwarding connection to the Grafana pod.

    kubectl port-forward deploy/grafana 3000:3000

Open Grafana in your browser at http://localhost:3000 the username is admin.

## Cleaning up

Deleting the Helm releases will remove all the resources we created.

    helm delete grafana prometheus scaphandre
