// Copyright 2024 Brian Smith.
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
// SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
// OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
// CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

use crate::testutil;
use core::{marker::PhantomData, mem::size_of};

/// A ZST that can be added to any type to make the type `!Send`.
#[derive(Clone, Copy)]
pub struct NotSend(PhantomData<*mut ()>);

impl NotSend {
    pub const VALUE: Self = Self(PhantomData);
}

#[allow(deprecated)]
const _: () = testutil::compile_time_assert_clone::<NotSend>();
#[allow(deprecated)]
const _: () = testutil::compile_time_assert_copy::<NotSend>();
const _: () = assert!(size_of::<NotSend>() == 0);
