# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtAutonomousDatabasesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_list_by_subscription(self, resource_group):
        response = self.client.autonomous_databases.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_create_or_update(self, resource_group):
        response = self.client.autonomous_databases.begin_create_or_update(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            resource={
                "location": "str",
                "id": "str",
                "name": "str",
                "properties": "autonomous_database_base_properties",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_get(self, resource_group):
        response = self.client.autonomous_databases.get(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_delete(self, resource_group):
        response = self.client.autonomous_databases.begin_delete(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_update(self, resource_group):
        response = self.client.autonomous_databases.begin_update(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            properties={
                "properties": {
                    "adminPassword": "str",
                    "autonomousMaintenanceScheduleType": "str",
                    "backupRetentionPeriodInDays": 0,
                    "computeCount": 0.0,
                    "cpuCoreCount": 0,
                    "customerContacts": [{"email": "str"}],
                    "dataStorageSizeInGbs": 0,
                    "dataStorageSizeInTbs": 0,
                    "databaseEdition": "str",
                    "displayName": "str",
                    "isAutoScalingEnabled": bool,
                    "isAutoScalingForStorageEnabled": bool,
                    "isLocalDataGuardEnabled": bool,
                    "isMtlsConnectionRequired": bool,
                    "licenseModel": "str",
                    "localAdgAutoFailoverMaxDataLossLimit": 0,
                    "longTermBackupSchedule": {
                        "isDisabled": bool,
                        "repeatCadence": "str",
                        "retentionPeriodInDays": 0,
                        "timeOfBackup": "2020-02-20 00:00:00",
                    },
                    "openMode": "str",
                    "peerDbId": "str",
                    "permissionLevel": "str",
                    "role": "str",
                    "scheduledOperations": {
                        "dayOfWeek": {"name": "str"},
                        "scheduledStartTime": "str",
                        "scheduledStopTime": "str",
                    },
                    "whitelistedIps": ["str"],
                },
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_list_by_resource_group(self, resource_group):
        response = self.client.autonomous_databases.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_switchover(self, resource_group):
        response = self.client.autonomous_databases.begin_switchover(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            body={"peerDbId": "str", "peerDbLocation": "str", "peerDbOcid": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_failover(self, resource_group):
        response = self.client.autonomous_databases.begin_failover(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            body={"peerDbId": "str", "peerDbLocation": "str", "peerDbOcid": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_generate_wallet(self, resource_group):
        response = self.client.autonomous_databases.generate_wallet(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            body={"password": "str", "generateType": "str", "isRegional": bool},
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_restore(self, resource_group):
        response = self.client.autonomous_databases.begin_restore(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            body={"timestamp": "2020-02-20 00:00:00"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_shrink(self, resource_group):
        response = self.client.autonomous_databases.begin_shrink(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_autonomous_databases_begin_change_disaster_recovery_configuration(self, resource_group):
        response = self.client.autonomous_databases.begin_change_disaster_recovery_configuration(
            resource_group_name=resource_group.name,
            autonomousdatabasename="str",
            body={
                "disasterRecoveryType": "str",
                "isReplicateAutomaticBackups": bool,
                "isSnapshotStandby": bool,
                "timeSnapshotStandbyEnabledTill": "2020-02-20 00:00:00",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
