# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementProjectsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_projects_list(self, resource_group):
        response = self.client.projects.list(
            group_name="str",
            service_name="str",
            api_version="2025-03-15-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_projects_create_or_update(self, resource_group):
        response = self.client.projects.create_or_update(
            group_name="str",
            service_name="str",
            project_name="str",
            parameters={
                "azureAuthenticationInfo": {
                    "appKey": "str",
                    "applicationId": "str",
                    "ignoreAzurePermissions": bool,
                    "tenantId": "str",
                },
                "creationTime": "2020-02-20 00:00:00",
                "databasesInfo": [{"sourceDatabaseName": "str"}],
                "etag": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "sourceConnectionInfo": "connection_info",
                "sourcePlatform": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "targetConnectionInfo": "connection_info",
                "targetPlatform": "str",
                "type": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_projects_get(self, resource_group):
        response = self.client.projects.get(
            group_name="str",
            service_name="str",
            project_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_projects_delete(self, resource_group):
        response = self.client.projects.delete(
            group_name="str",
            service_name="str",
            project_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_projects_update(self, resource_group):
        response = self.client.projects.update(
            group_name="str",
            service_name="str",
            project_name="str",
            parameters={
                "azureAuthenticationInfo": {
                    "appKey": "str",
                    "applicationId": "str",
                    "ignoreAzurePermissions": bool,
                    "tenantId": "str",
                },
                "creationTime": "2020-02-20 00:00:00",
                "databasesInfo": [{"sourceDatabaseName": "str"}],
                "etag": "str",
                "id": "str",
                "location": "str",
                "name": "str",
                "provisioningState": "str",
                "sourceConnectionInfo": "connection_info",
                "sourcePlatform": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "targetConnectionInfo": "connection_info",
                "targetPlatform": "str",
                "type": "str",
            },
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...
