# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementDatabaseMigrationsSqlVmOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_vm_get(self, resource_group):
        response = self.client.database_migrations_sql_vm.get(
            resource_group_name=resource_group.name,
            sql_virtual_machine_name="str",
            target_db_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_vm_begin_create_or_update(self, resource_group):
        response = self.client.database_migrations_sql_vm.begin_create_or_update(
            resource_group_name=resource_group.name,
            sql_virtual_machine_name="str",
            target_db_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "kind": "SqlVm",
                    "backupConfiguration": {
                        "sourceLocation": {
                            "azureBlob": {
                                "accountKey": "str",
                                "authType": "str",
                                "blobContainerName": "str",
                                "identity": {
                                    "type": "str",
                                    "principalId": "str",
                                    "tenantId": "str",
                                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                                },
                                "storageAccountResourceId": "str",
                            },
                            "fileShare": {"password": "str", "path": "str", "username": "str"},
                            "fileStorageType": "str",
                        },
                        "targetLocation": {"accountKey": "str", "storageAccountResourceId": "str"},
                    },
                    "endedOn": "2020-02-20 00:00:00",
                    "migrationFailureError": {"code": "str", "message": "str"},
                    "migrationOperationId": "str",
                    "migrationService": "str",
                    "migrationStatus": "str",
                    "migrationStatusDetails": {
                        "activeBackupSets": [
                            {
                                "backupFinishDate": "2020-02-20 00:00:00",
                                "backupSetId": "str",
                                "backupStartDate": "2020-02-20 00:00:00",
                                "backupType": "str",
                                "familyCount": 0,
                                "firstLSN": "str",
                                "hasBackupChecksums": bool,
                                "ignoreReasons": ["str"],
                                "isBackupRestored": bool,
                                "lastLSN": "str",
                                "listOfBackupFiles": [
                                    {
                                        "copyDuration": 0,
                                        "copyThroughput": 0.0,
                                        "dataRead": 0,
                                        "dataWritten": 0,
                                        "familySequenceNumber": 0,
                                        "fileName": "str",
                                        "status": "str",
                                        "totalSize": 0,
                                    }
                                ],
                            }
                        ],
                        "blobContainerName": "str",
                        "completeRestoreErrorMessage": "str",
                        "currentRestoringFilename": "str",
                        "fileUploadBlockingErrors": ["str"],
                        "fullBackupSetInfo": {
                            "backupFinishDate": "2020-02-20 00:00:00",
                            "backupSetId": "str",
                            "backupStartDate": "2020-02-20 00:00:00",
                            "backupType": "str",
                            "familyCount": 0,
                            "firstLSN": "str",
                            "hasBackupChecksums": bool,
                            "ignoreReasons": ["str"],
                            "isBackupRestored": bool,
                            "lastLSN": "str",
                            "listOfBackupFiles": [
                                {
                                    "copyDuration": 0,
                                    "copyThroughput": 0.0,
                                    "dataRead": 0,
                                    "dataWritten": 0,
                                    "familySequenceNumber": 0,
                                    "fileName": "str",
                                    "status": "str",
                                    "totalSize": 0,
                                }
                            ],
                        },
                        "invalidFiles": ["str"],
                        "isFullBackupRestored": bool,
                        "lastRestoredBackupSetInfo": {
                            "backupFinishDate": "2020-02-20 00:00:00",
                            "backupSetId": "str",
                            "backupStartDate": "2020-02-20 00:00:00",
                            "backupType": "str",
                            "familyCount": 0,
                            "firstLSN": "str",
                            "hasBackupChecksums": bool,
                            "ignoreReasons": ["str"],
                            "isBackupRestored": bool,
                            "lastLSN": "str",
                            "listOfBackupFiles": [
                                {
                                    "copyDuration": 0,
                                    "copyThroughput": 0.0,
                                    "dataRead": 0,
                                    "dataWritten": 0,
                                    "familySequenceNumber": 0,
                                    "fileName": "str",
                                    "status": "str",
                                    "totalSize": 0,
                                }
                            ],
                        },
                        "lastRestoredFilename": "str",
                        "migrationState": "str",
                        "pendingLogBackupsCount": 0,
                        "restoreBlockingReason": "str",
                    },
                    "offlineConfiguration": {"lastBackupName": "str", "offline": bool},
                    "provisioningError": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "sourceDatabaseName": "str",
                    "sourceServerName": "str",
                    "sourceSqlConnection": {
                        "authentication": "str",
                        "dataSource": "str",
                        "encryptConnection": bool,
                        "password": "str",
                        "trustServerCertificate": bool,
                        "userName": "str",
                    },
                    "startedOn": "2020-02-20 00:00:00",
                    "targetDatabaseCollation": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_vm_begin_cancel(self, resource_group):
        response = self.client.database_migrations_sql_vm.begin_cancel(
            resource_group_name=resource_group.name,
            sql_virtual_machine_name="str",
            target_db_name="str",
            parameters={"migrationOperationId": "str"},
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_vm_begin_cutover(self, resource_group):
        response = self.client.database_migrations_sql_vm.begin_cutover(
            resource_group_name=resource_group.name,
            sql_virtual_machine_name="str",
            target_db_name="str",
            parameters={"migrationOperationId": "str"},
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
