# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.datamigration import DataMigrationManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-datamigration
# USAGE
    python cosmos_db_mongo_create_or_update_database_migration_min.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DataMigrationManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-1111-2222-3333-444444444444",
    )

    response = client.database_migrations_mongo_to_cosmos_db_ru_mongo.begin_create(
        resource_group_name="testrg",
        target_resource_name="targetCosmosDbClusterName",
        migration_name="migrationRequest",
        parameters={
            "properties": {
                "collectionList": [
                    {
                        "sourceCollection": "sourceCol1",
                        "sourceDatabase": "sourceDb1",
                        "targetCollection": "targetCol1",
                        "targetDatabase": "targetDb1",
                    },
                    {"sourceCollection": "sourceCol2", "sourceDatabase": "sourceDb2"},
                ],
                "kind": "MongoToCosmosDbMongo",
                "migrationService": "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/MigrationServices/testMigrationService",
                "scope": "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DocumentDB/mongoClusters/targetCosmosDbClusterName",
                "sourceMongoConnection": {
                    "host": "abc.mongodb.com",
                    "password": "placeholder",
                    "port": 88,
                    "useSsl": True,
                    "userName": "abc",
                },
                "targetMongoConnection": {"connectionString": "placeholder"},
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2025-03-15-preview/examples/CosmosDbMongoCreateOrUpdateDatabaseMigrationMIN.json
if __name__ == "__main__":
    main()
