# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementGalleriesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_galleries_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.galleries.begin_create_or_update(
                resource_group_name=resource_group.name,
                gallery_name="str",
                gallery={
                    "location": "str",
                    "description": "str",
                    "id": "str",
                    "identifier": {"uniqueName": "str"},
                    "name": "str",
                    "provisioningState": "str",
                    "sharingProfile": {
                        "communityGalleryInfo": {
                            "communityGalleryEnabled": bool,
                            "eula": "str",
                            "publicNamePrefix": "str",
                            "publicNames": ["str"],
                            "publisherContact": "str",
                            "publisherUri": "str",
                        },
                        "groups": [{"ids": ["str"], "type": "str"}],
                        "permissions": "str",
                    },
                    "sharingStatus": {
                        "aggregatedState": "str",
                        "summary": [{"details": "str", "region": "str", "state": "str"}],
                    },
                    "softDeletePolicy": {"isSoftDeleteEnabled": bool},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2023-07-03",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_galleries_begin_update(self, resource_group):
        response = await (
            await self.client.galleries.begin_update(
                resource_group_name=resource_group.name,
                gallery_name="str",
                gallery={
                    "description": "str",
                    "id": "str",
                    "identifier": {"uniqueName": "str"},
                    "name": "str",
                    "provisioningState": "str",
                    "sharingProfile": {
                        "communityGalleryInfo": {
                            "communityGalleryEnabled": bool,
                            "eula": "str",
                            "publicNamePrefix": "str",
                            "publicNames": ["str"],
                            "publisherContact": "str",
                            "publisherUri": "str",
                        },
                        "groups": [{"ids": ["str"], "type": "str"}],
                        "permissions": "str",
                    },
                    "sharingStatus": {
                        "aggregatedState": "str",
                        "summary": [{"details": "str", "region": "str", "state": "str"}],
                    },
                    "softDeletePolicy": {"isSoftDeleteEnabled": bool},
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2023-07-03",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_galleries_get(self, resource_group):
        response = await self.client.galleries.get(
            resource_group_name=resource_group.name,
            gallery_name="str",
            api_version="2023-07-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_galleries_begin_delete(self, resource_group):
        response = await (
            await self.client.galleries.begin_delete(
                resource_group_name=resource_group.name,
                gallery_name="str",
                api_version="2023-07-03",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_galleries_list_by_resource_group(self, resource_group):
        response = self.client.galleries.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-07-03",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_galleries_list(self, resource_group):
        response = self.client.galleries.list(
            api_version="2023-07-03",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
