# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementDisksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_begin_create_or_update(self, resource_group):
        response = self.client.disks.begin_create_or_update(
            resource_group_name=resource_group.name,
            disk_name="str",
            disk={
                "location": "str",
                "LastOwnershipUpdateTime": "2020-02-20 00:00:00",
                "burstingEnabled": bool,
                "burstingEnabledTime": "2020-02-20 00:00:00",
                "completionPercent": 0.0,
                "creationData": {
                    "createOption": "str",
                    "elasticSanResourceId": "str",
                    "galleryImageReference": {
                        "communityGalleryImageId": "str",
                        "id": "str",
                        "lun": 0,
                        "sharedGalleryImageId": "str",
                    },
                    "imageReference": {
                        "communityGalleryImageId": "str",
                        "id": "str",
                        "lun": 0,
                        "sharedGalleryImageId": "str",
                    },
                    "logicalSectorSize": 0,
                    "performancePlus": bool,
                    "provisionedBandwidthCopySpeed": "str",
                    "securityDataUri": "str",
                    "sourceResourceId": "str",
                    "sourceUniqueId": "str",
                    "sourceUri": "str",
                    "storageAccountId": "str",
                    "uploadSizeBytes": 0,
                },
                "dataAccessAuthMode": "str",
                "diskAccessId": "str",
                "diskIOPSReadOnly": 0,
                "diskIOPSReadWrite": 0,
                "diskMBpsReadOnly": 0,
                "diskMBpsReadWrite": 0,
                "diskSizeBytes": 0,
                "diskSizeGB": 0,
                "diskState": "str",
                "encryption": {"diskEncryptionSetId": "str", "type": "str"},
                "encryptionSettingsCollection": {
                    "enabled": bool,
                    "encryptionSettings": [
                        {
                            "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                            "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                        }
                    ],
                    "encryptionSettingsVersion": "str",
                },
                "extendedLocation": {"name": "str", "type": "str"},
                "hyperVGeneration": "str",
                "id": "str",
                "managedBy": "str",
                "managedByExtended": ["str"],
                "maxShares": 0,
                "name": "str",
                "networkAccessPolicy": "str",
                "optimizedForFrequentAttach": bool,
                "osType": "str",
                "propertyUpdatesInProgress": {"targetTier": "str"},
                "provisioningState": "str",
                "publicNetworkAccess": "str",
                "purchasePlan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str"},
                "securityProfile": {"secureVMDiskEncryptionSetId": "str", "securityType": "str"},
                "shareInfo": [{"vmUri": "str"}],
                "sku": {"name": "str", "tier": "str"},
                "supportedCapabilities": {
                    "acceleratedNetwork": bool,
                    "architecture": "str",
                    "diskControllerTypes": "str",
                },
                "supportsHibernation": bool,
                "tags": {"str": "str"},
                "tier": "str",
                "timeCreated": "2020-02-20 00:00:00",
                "type": "str",
                "uniqueId": "str",
                "zones": ["str"],
            },
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_begin_update(self, resource_group):
        response = self.client.disks.begin_update(
            resource_group_name=resource_group.name,
            disk_name="str",
            disk={
                "burstingEnabled": bool,
                "dataAccessAuthMode": "str",
                "diskAccessId": "str",
                "diskIOPSReadOnly": 0,
                "diskIOPSReadWrite": 0,
                "diskMBpsReadOnly": 0,
                "diskMBpsReadWrite": 0,
                "diskSizeGB": 0,
                "encryption": {"diskEncryptionSetId": "str", "type": "str"},
                "encryptionSettingsCollection": {
                    "enabled": bool,
                    "encryptionSettings": [
                        {
                            "diskEncryptionKey": {"secretUrl": "str", "sourceVault": {"id": "str"}},
                            "keyEncryptionKey": {"keyUrl": "str", "sourceVault": {"id": "str"}},
                        }
                    ],
                    "encryptionSettingsVersion": "str",
                },
                "maxShares": 0,
                "networkAccessPolicy": "str",
                "optimizedForFrequentAttach": bool,
                "osType": "str",
                "propertyUpdatesInProgress": {"targetTier": "str"},
                "publicNetworkAccess": "str",
                "purchasePlan": {"name": "str", "product": "str", "publisher": "str", "promotionCode": "str"},
                "sku": {"name": "str", "tier": "str"},
                "supportedCapabilities": {
                    "acceleratedNetwork": bool,
                    "architecture": "str",
                    "diskControllerTypes": "str",
                },
                "supportsHibernation": bool,
                "tags": {"str": "str"},
                "tier": "str",
            },
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_get(self, resource_group):
        response = self.client.disks.get(
            resource_group_name=resource_group.name,
            disk_name="str",
            api_version="2023-10-02",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_begin_delete(self, resource_group):
        response = self.client.disks.begin_delete(
            resource_group_name=resource_group.name,
            disk_name="str",
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_list_by_resource_group(self, resource_group):
        response = self.client.disks.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-10-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_list(self, resource_group):
        response = self.client.disks.list(
            api_version="2023-10-02",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_begin_grant_access(self, resource_group):
        response = self.client.disks.begin_grant_access(
            resource_group_name=resource_group.name,
            disk_name="str",
            grant_access_data={
                "access": "str",
                "durationInSeconds": 0,
                "fileFormat": "str",
                "getSecureVMGuestStateSAS": bool,
            },
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_disks_begin_revoke_access(self, resource_group):
        response = self.client.disks.begin_revoke_access(
            resource_group_name=resource_group.name,
            disk_name="str",
            api_version="2023-10-02",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
