# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIContainerAppsDiagnosticsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_container_apps_diagnostics_list_detectors(self, resource_group):
        response = self.client.container_apps_diagnostics.list_detectors(
            resource_group_name=resource_group.name,
            container_app_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_container_apps_diagnostics_get_detector(self, resource_group):
        response = self.client.container_apps_diagnostics.get_detector(
            resource_group_name=resource_group.name,
            container_app_name="str",
            detector_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_container_apps_diagnostics_list_revisions(self, resource_group):
        response = self.client.container_apps_diagnostics.list_revisions(
            resource_group_name=resource_group.name,
            container_app_name="str",
            api_version="2025-02-02-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_container_apps_diagnostics_get_revision(self, resource_group):
        response = self.client.container_apps_diagnostics.get_revision(
            resource_group_name=resource_group.name,
            container_app_name="str",
            revision_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_container_apps_diagnostics_get_root(self, resource_group):
        response = self.client.container_apps_diagnostics.get_root(
            resource_group_name=resource_group.name,
            container_app_name="str",
            api_version="2025-02-02-preview",
        )

        # please add some check logic here by yourself
        # ...
