# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import ClientEventType, ContentPartType, ItemType, ServerEventType, ToolType

if TYPE_CHECKING:
    from .. import _types, models as _models


class AgentConfig(_Model):
    """AgentConfig.

    :ivar type: Required. Default value is "agent".
    :vartype type: str
    :ivar name: Required.
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar agent_id: Required.
    :vartype agent_id: str
    :ivar thread_id: Required.
    :vartype thread_id: str
    """

    type: Literal["agent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"agent\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    agent_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    thread_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        agent_id: str,
        thread_id: str,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["agent"] = "agent"


class Animation(_Model):
    """Configuration for animation outputs including blendshapes, visemes, and emotion metadata.

    :ivar model_name: The name of the animation model to use.
    :vartype model_name: str
    :ivar outputs: Set of output data types requested from the animation system.
    :vartype outputs: list[str or ~azure.ai.voicelive.models.AnimationOutputType]
    :ivar emotion_detection_interval_ms: Interval for emotion detection in milliseconds. If not
     set, emotion detection is disabled.
    :vartype emotion_detection_interval_ms: int
    """

    model_name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the animation model to use."""
    outputs: Optional[List[Union[str, "_models.AnimationOutputType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of output data types requested from the animation system."""
    emotion_detection_interval_ms: Optional[int] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Interval for emotion detection in milliseconds. If not set, emotion detection is disabled."""

    @overload
    def __init__(
        self,
        *,
        model_name: Optional[str] = None,
        outputs: Optional[List[Union[str, "_models.AnimationOutputType"]]] = None,
        emotion_detection_interval_ms: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ConversationRequestItem(_Model):
    """Base for any response item; discriminated by ``type``.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FunctionCallItem, FunctionCallOutputItem, MessageItem

    :ivar type: Required. Known values are: "message", "function_call", and "function_call_output".
    :vartype type: str or ~azure.ai.voicelive.models.ItemType
    :ivar id:
    :vartype id: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"message\", \"function_call\", and \"function_call_output\"."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MessageItem(ConversationRequestItem, discriminator="message"):
    """MessageItem.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AssistantMessageItem, SystemMessageItem, UserMessageItem

    :ivar id:
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar role: Required. Default value is None.
    :vartype role: str
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    """

    __mapping__: Dict[str, _Model] = {}
    type: Literal[ItemType.MESSAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    role: str = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""
    status: Optional[Union[str, "_models.ItemParamStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"completed\" and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        role: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ItemType.MESSAGE, **kwargs)


class AssistantMessageItem(MessageItem, discriminator="assistant"):
    """AssistantMessageItem.

    :ivar id:
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    :ivar role: Required. Default value is "assistant".
    :vartype role: str
    :ivar content: Required.
    :vartype content: list[~azure.ai.voicelive.models.OutputTextContentPart]
    """

    __mapping__: Dict[str, _Model] = {}
    role: Literal["assistant"] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"assistant\"."""
    content: List["_models.OutputTextContentPart"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        content: List["_models.OutputTextContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, role="assistant", **kwargs)


class AudioEchoCancellation(_Model):
    """Echo cancellation configuration for server-side audio processing.

    :ivar type: The type of echo cancellation model to use. Required. Default value is
     "server_echo_cancellation".
    :vartype type: str
    """

    type: Literal["server_echo_cancellation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of echo cancellation model to use. Required. Default value is
     \"server_echo_cancellation\"."""

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["server_echo_cancellation"] = "server_echo_cancellation"


class AudioInputTranscriptionSettings(_Model):
    """Configuration for input audio transcription.

    :ivar model: The model used for transcription. E.g., 'whisper-1', 'azure-fast-transcription',
     's2s-ingraph'. Required. Is one of the following types: Literal["whisper-1"],
     Literal["azure-fast-transcription"], Literal["s2s-ingraph"]
    :vartype model: str
    :ivar language: The language code to use for transcription, if specified.
    :vartype language: str
    :ivar enabled: Whether transcription is enabled. Required.
    :vartype enabled: bool
    :ivar custom_model: Whether a custom model is being used. Required.
    :vartype custom_model: bool
    """

    model: Literal["whisper-1", "azure-fast-transcription", "s2s-ingraph"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The model used for transcription. E.g., 'whisper-1', 'azure-fast-transcription', 's2s-ingraph'.
     Required. Is one of the following types: Literal[\"whisper-1\"],
     Literal[\"azure-fast-transcription\"], Literal[\"s2s-ingraph\"]"""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language code to use for transcription, if specified."""
    enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether transcription is enabled. Required."""
    custom_model: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether a custom model is being used. Required."""

    @overload
    def __init__(
        self,
        *,
        model: Literal["whisper-1", "azure-fast-transcription", "s2s-ingraph"],
        enabled: bool,
        custom_model: bool,
        language: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AudioNoiseReduction(_Model):
    """Configuration for input audio noise reduction.

    :ivar type: The type of noise reduction model. Required. Default value is
     "azure_deep_noise_suppression".
    :vartype type: str
    """

    type: Literal["azure_deep_noise_suppression"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of noise reduction model. Required. Default value is \"azure_deep_noise_suppression\"."""

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["azure_deep_noise_suppression"] = "azure_deep_noise_suppression"


class AvatarConfig(_Model):
    """Configuration for avatar streaming and behavior during the session.

    :ivar ice_servers: Optional list of ICE servers to use for WebRTC connection establishment.
    :vartype ice_servers: list[~azure.ai.voicelive.models.IceServer]
    :ivar character: The character name or ID used for the avatar. Required.
    :vartype character: str
    :ivar style: Optional avatar style, such as emotional tone or speaking style.
    :vartype style: str
    :ivar customized: Indicates whether the avatar is customized or not. Required.
    :vartype customized: bool
    :ivar video: Optional video configuration including resolution, bitrate, and codec.
    :vartype video: ~azure.ai.voicelive.models.VideoParams
    """

    ice_servers: Optional[List["_models.IceServer"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional list of ICE servers to use for WebRTC connection establishment."""
    character: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The character name or ID used for the avatar. Required."""
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional avatar style, such as emotional tone or speaking style."""
    customized: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates whether the avatar is customized or not. Required."""
    video: Optional["_models.VideoParams"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional video configuration including resolution, bitrate, and codec."""

    @overload
    def __init__(
        self,
        *,
        character: str,
        customized: bool,
        ice_servers: Optional[List["_models.IceServer"]] = None,
        style: Optional[str] = None,
        video: Optional["_models.VideoParams"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureVoice(_Model):
    """Base for Azure voice configurations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureCustomVoice, AzurePersonalVoice, AzureStandardVoice

    :ivar type: Required. Default value is None.
    :vartype type: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureCustomVoice(AzureVoice, discriminator="azure-custom"):
    """Azure custom voice configuration (preferred).

    :ivar type: Required. Defaults to ``"azure-custom"``.
        The legacy alias ``"custom"`` is accepted but **deprecated**.
    :vartype type: str
    :ivar name: Voice name. Must be non-empty.
    :vartype name: str
    :ivar endpoint_id: Endpoint ID. Must be non-empty.
    :vartype endpoint_id: str
    :ivar temperature: Generation temperature (0.0–1.0).
    :vartype temperature: float | None
    :ivar custom_lexicon_url: Optional lexicon URL.
    :vartype custom_lexicon_url: str | None
    :ivar prefer_locales: Preferred locale tags (e.g., ``"en-US"``).
    :vartype prefer_locales: list[str] | None
    :ivar locale: Primary locale tag.
    :vartype locale: str | None
    :ivar style: Optional speaking style.
    :vartype style: str | None
    :ivar pitch: Optional pitch directive.
    :vartype pitch: str | None
    :ivar rate: Optional speaking rate directive.
    :vartype rate: str | None
    :ivar volume: Optional volume directive.
    :vartype volume: str | None
    """


    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    endpoint_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    custom_lexicon_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefer_locales: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    pitch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    rate: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    volume: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: Literal["azure-custom", "custom"] = "azure-custom",
        name: str,
        endpoint_id: str,
        temperature: Optional[float] = None,
        custom_lexicon_url: Optional[str] = None,
        prefer_locales: Optional[List[str]] = None,
        locale: Optional[str] = None,
        style: Optional[str] = None,
        pitch: Optional[str] = None,
        rate: Optional[str] = None,
        volume: Optional[str] = None,
    ) -> None: ...
    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None: ...

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        type_value = kwargs.pop("type", "azure-custom")
        if type_value == "custom":
            type_value = "azure-custom"
        super().__init__(*args, type=type_value, **kwargs)


class TurnDetection(_Model):
    """Top-level union for turn detection configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureSemanticVad, AzureMultilingualSemanticVad, NoTurnDetection, ServerVad

    :ivar type: Required. Is one of the following types: Literal["none"], Literal["server_vad"],
     Literal["azure_semantic_vad"], Literal["azure_semantic_vad_en"], Literal["server_sd"],
     Literal["azure_semantic_vad_multilingual"]
    :vartype type: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Is one of the following types: Literal[\"none\"], Literal[\"server_vad\"],
     Literal[\"azure_semantic_vad\"], Literal[\"azure_semantic_vad_en\"], Literal[\"server_sd\"],
     Literal[\"azure_semantic_vad_multilingual\"]"""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureMultilingualSemanticVad(TurnDetection, discriminator="azure_semantic_vad_multilingual"):
    """Server Speech Detection (Azure semantic VAD).

    :ivar type: Required. Default value is "azure_semantic_vad_multilingual".
    :vartype type: str
    :ivar threshold:
    :vartype threshold: float
    :ivar prefix_padding_ms:
    :vartype prefix_padding_ms: int
    :ivar silence_duration_ms:
    :vartype silence_duration_ms: int
    :ivar end_of_utterance_detection:
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EOUDetection
    :ivar neg_threshold:
    :vartype neg_threshold: float
    :ivar speech_duration_ms:
    :vartype speech_duration_ms: int
    :ivar window_size:
    :vartype window_size: int
    :ivar distinct_ci_phones:
    :vartype distinct_ci_phones: int
    :ivar require_vowel:
    :vartype require_vowel: bool
    :ivar remove_filler_words:
    :vartype remove_filler_words: bool
    :ivar languages:
    :vartype languages: list[str]
    :ivar auto_truncate:
    :vartype auto_truncate: bool
    """

    type: Literal["azure_semantic_vad_multilingual"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"azure_semantic_vad_multilingual\"."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EOUDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    neg_threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    speech_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    window_size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    distinct_ci_phones: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    require_vowel: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    remove_filler_words: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    languages: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EOUDetection"] = None,
        neg_threshold: Optional[float] = None,
        speech_duration_ms: Optional[int] = None,
        window_size: Optional[int] = None,
        distinct_ci_phones: Optional[int] = None,
        require_vowel: Optional[bool] = None,
        remove_filler_words: Optional[bool] = None,
        languages: Optional[List[str]] = None,
        auto_truncate: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="azure_semantic_vad_multilingual", **kwargs)


class AzurePersonalVoice(AzureVoice, discriminator="azure-personal"):
    """Azure personal voice configuration.

    :ivar type: Required. Default value is "azure-personal".
    :vartype type: str
    :ivar name: Voice name cannot be empty. Required.
    :vartype name: str
    :ivar temperature: Temperature must be between 0.0 and 1.0.
    :vartype temperature: float
    :ivar model: Underlying neural model to use for personal voice. Required. Is one of the
     following types: Literal["DragonLatestNeural"], Literal["PhoenixLatestNeural"],
     Literal["PhoenixV2Neural"]
    :vartype model: str
    """

    type: Literal["azure-personal"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"azure-personal\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Voice name cannot be empty. Required."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Temperature must be between 0.0 and 1.0."""
    model: Literal["DragonLatestNeural", "PhoenixLatestNeural", "PhoenixV2Neural"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Underlying neural model to use for personal voice. Required. Is one of the following types:
     Literal[\"DragonLatestNeural\"], Literal[\"PhoenixLatestNeural\"], Literal[\"PhoenixV2Neural\"]"""

    @overload
    def __init__(
        self,
        *,
        name: str,
        model: Literal["DragonLatestNeural", "PhoenixLatestNeural", "PhoenixV2Neural"],
        temperature: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="azure-personal", **kwargs)


class EOUDetection(_Model):
    """Top-level union for end-of-utterance (EOU) semantic detection configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureSemanticDetection, AzureSemanticDetectionMultilingual

    :ivar model: Required. Is one of the following types: Literal["semantic_detection_v1"],
     Literal["semantic_detection_v1_en"], Literal["semantic_detection_v1_multilingual"]
    :vartype model: str
    """

    __mapping__: Dict[str, _Model] = {}
    model: str = rest_discriminator(name="model", visibility=["read", "create", "update", "delete", "query"])
    """Required. Is one of the following types: Literal[\"semantic_detection_v1\"],
     Literal[\"semantic_detection_v1_en\"], Literal[\"semantic_detection_v1_multilingual\"]"""

    @overload
    def __init__(
        self,
        *,
        model: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureSemanticDetection(EOUDetection, discriminator="semantic_detection_v1"):
    """Azure semantic end-of-utterance detection.

    Default discriminator is ``"semantic_detection_v1"``; pass
    ``model="semantic_detection_v1_en"`` to use the English-labeled variant.
    The field set is identical for both labels.

    :ivar model: Discriminator for this EOU model. Defaults to
        ``"semantic_detection_v1"``; may also be ``"semantic_detection_v1_en"``.
    :vartype model: str
    :ivar threshold: Primary detection threshold (0.0–1.0).
    :vartype threshold: float | None
    :ivar timeout: Primary timeout in seconds.
    :vartype timeout: float | None
    :ivar secondary_threshold: Secondary detection threshold (0.0–1.0).
    :vartype secondary_threshold: float | None
    :ivar secondary_timeout: Secondary timeout in seconds.
    :vartype secondary_timeout: float | None
    :ivar disable_rules: If ``True``, disables heuristic rules and relies on
        scores/timeouts only.
    :vartype disable_rules: bool | None
    :ivar sr_boost: Optional score boost applied to ASR-aligned cues (0.0–1.0).
    :vartype sr_boost: float | None
    :ivar extra_imend_check: If ``True``, runs an additional end-of-utterance
        verification pass.
    :vartype extra_imend_check: bool | None
    """

    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    timeout: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    secondary_threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    secondary_timeout: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    disable_rules: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    sr_boost: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    extra_imend_check: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        model: Literal["semantic_detection_v1", "semantic_detection_v1_en"] = "semantic_detection_v1",
        threshold: Optional[float] = ...,
        timeout: Optional[float] = ...,
        secondary_threshold: Optional[float] = ...,
        secondary_timeout: Optional[float] = ...,
        disable_rules: Optional[bool] = ...,
        sr_boost: Optional[float] = ...,
        extra_imend_check: Optional[bool] = ...,
    ) -> None: ...
    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None: ...

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        model_value = kwargs.pop("model", "semantic_detection_v1")
        if model_value not in ("semantic_detection_v1", "semantic_detection_v1_en"):
            raise ValueError("model must be 'semantic_detection_v1' or 'semantic_detection_v1_en'")
        super().__init__(*args, model=model_value, **kwargs)


class AzureSemanticDetectionMultilingual(EOUDetection, discriminator="semantic_detection_v1_multilingual"):
    """Azure semantic end-of-utterance detection (multilingual).

    :ivar model: Required. Default value is "semantic_detection_v1_multilingual".
    :vartype model: str
    :ivar threshold:
    :vartype threshold: float
    :ivar timeout:
    :vartype timeout: float
    :ivar secondary_threshold:
    :vartype secondary_threshold: float
    :ivar secondary_timeout:
    :vartype secondary_timeout: float
    :ivar disable_rules:
    :vartype disable_rules: bool
    :ivar sr_boost:
    :vartype sr_boost: float
    :ivar extra_imend_check:
    :vartype extra_imend_check: bool
    """

    model: Literal["semantic_detection_v1_multilingual"] = rest_discriminator(name="model", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"semantic_detection_v1_multilingual\"."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    timeout: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    secondary_threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    secondary_timeout: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    disable_rules: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    sr_boost: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    extra_imend_check: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        timeout: Optional[float] = None,
        secondary_threshold: Optional[float] = None,
        secondary_timeout: Optional[float] = None,
        disable_rules: Optional[bool] = None,
        sr_boost: Optional[float] = None,
        extra_imend_check: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, model="semantic_detection_v1_multilingual", **kwargs)


class AzureSemanticVad(TurnDetection, discriminator="azure_semantic_vad"):
    """Server Speech Detection (Azure semantic VAD, default variant).

    Default discriminator is ``"azure_semantic_vad"``. You may also pass
    ``type="azure_semantic_vad_en"`` (English-labeled) or ``type="server_sd"``
    (legacy alias) for compatibility; the field set is the same.

    :ivar type: Discriminator for this VAD. Defaults to ``"azure_semantic_vad"``.
        May also be ``"azure_semantic_vad_en"`` or (legacy) ``"server_sd"``.
    :vartype type: str
    :ivar threshold: Primary detection threshold (0.0–1.0).
    :vartype threshold: float | None
    :ivar prefix_padding_ms: Audio kept before detected speech (ms).
    :vartype prefix_padding_ms: int | None
    :ivar silence_duration_ms: Required trailing silence to mark end (ms).
    :vartype silence_duration_ms: int | None
    :ivar end_of_utterance_detection: Optional semantic EOU detector config.
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EOUDetection | None
    :ivar neg_threshold: Negative evidence threshold (0.0–1.0).
    :vartype neg_threshold: float | None
    :ivar speech_duration_ms: Minimum speech duration to trigger (ms).
    :vartype speech_duration_ms: int | None
    :ivar window_size: Sliding window size for scoring (ms).
    :vartype window_size: int | None
    :ivar distinct_ci_phones: Distinct case-insensitive phones required.
    :vartype distinct_ci_phones: int | None
    :ivar require_vowel: If ``True``, require a vowel to mark end.
    :vartype require_vowel: bool | None
    :ivar remove_filler_words: If ``True``, drop common fillers from ASR cues.
    :vartype remove_filler_words: bool | None
    :ivar languages: Optional list of language tags (e.g., ``"en-US"``).
    :vartype languages: list[str] | None
    :ivar auto_truncate: If ``True``, truncate long speech segments automatically.
    :vartype auto_truncate: bool | None
    """

    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EOUDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    neg_threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    speech_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    window_size: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    distinct_ci_phones: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    require_vowel: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    remove_filler_words: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    languages: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: Literal["azure_semantic_vad", "azure_semantic_vad_en", "server_sd"] = "azure_semantic_vad",
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EOUDetection"] = None,
        neg_threshold: Optional[float] = None,
        speech_duration_ms: Optional[int] = None,
        window_size: Optional[int] = None,
        distinct_ci_phones: Optional[int] = None,
        require_vowel: Optional[bool] = None,
        remove_filler_words: Optional[bool] = None,
        languages: Optional[List[str]] = None,
        auto_truncate: Optional[bool] = None,
    ) -> None: ...
    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None: ...

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        type_value = kwargs.pop("type", "azure_semantic_vad")
        if type_value == "server_sd":
            # normalize legacy alias to canonical discriminator
            type_value = "azure_semantic_vad"
        elif type_value not in ("azure_semantic_vad", "azure_semantic_vad_en"):
            raise ValueError(
                "type must be 'azure_semantic_vad', 'azure_semantic_vad_en', or legacy 'server_sd'"
            )
        super().__init__(*args, type=type_value, **kwargs)


class AzureStandardVoice(AzureVoice, discriminator="azure-standard"):
    """Azure standard voice configuration.

    :ivar type: Discriminator for this voice. Defaults to ``"azure-standard"``.
        The variant ``"azure-platform"`` is also accepted.
    :vartype type: str
    :ivar name: Voice name. Must be non-empty.
    :vartype name: str
    :ivar temperature: Generation temperature (0.0–1.0).
    :vartype temperature: float | None
    :ivar custom_lexicon_url: Optional lexicon URL.
    :vartype custom_lexicon_url: str | None
    :ivar prefer_locales: Preferred locale tags (e.g., ``"en-US"``).
    :vartype prefer_locales: list[str] | None
    :ivar locale: Primary locale tag.
    :vartype locale: str | None
    :ivar style: Optional speaking style.
    :vartype style: str | None
    :ivar pitch: Optional pitch directive.
    :vartype pitch: str | None
    :ivar rate: Optional speaking rate directive.
    :vartype rate: str | None
    :ivar volume: Optional volume directive.
    :vartype volume: str | None
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    custom_lexicon_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefer_locales: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    locale: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    style: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    pitch: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    rate: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    volume: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: Literal["azure-standard", "azure-platform"] = "azure-standard",
        name: str,
        temperature: Optional[float] = None,
        custom_lexicon_url: Optional[str] = None,
        prefer_locales: Optional[List[str]] = None,
        locale: Optional[str] = None,
        style: Optional[str] = None,
        pitch: Optional[str] = None,
        rate: Optional[str] = None,
        volume: Optional[str] = None,
    ) -> None: ...
    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None: ...

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        type_value = kwargs.pop("type", "azure-standard")
        if type_value not in ("azure-standard", "azure-platform"):
            raise ValueError("type must be 'azure-standard' or 'azure-platform'")
        super().__init__(*args, type=type_value, **kwargs)


class ClientEvent(_Model):
    """A voicelive client event.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ClientEventConversationItemCreate, ClientEventConversationItemDelete,
    ClientEventConversationItemRetrieve, ClientEventConversationItemTruncate,
    ClientEventInputAudioClear, ClientEventInputAudioTurnAppend, ClientEventInputAudioTurnCancel,
    ClientEventInputAudioTurnEnd, ClientEventInputAudioTurnStart,
    ClientEventInputAudioBufferAppend, ClientEventInputAudioBufferClear,
    ClientEventInputAudioBufferCommit, ClientEventResponseCancel, ClientEventResponseCreate,
    ClientEventSessionAvatarConnect, ClientEventSessionUpdate

    :ivar type: The type of event. Required. Known values are: "session.update",
     "input_audio_buffer.append", "input_audio_buffer.commit", "input_audio_buffer.clear",
     "input_audio.turn.start", "input_audio.turn.append", "input_audio.turn.end",
     "input_audio.turn.cancel", "input_audio.clear", "conversation.item.create",
     "conversation.item.retrieve", "conversation.item.truncate", "conversation.item.delete",
     "response.create", "response.cancel", and "session.avatar.connect".
    :vartype type: str or ~azure.ai.voicelive.models.ClientEventType
    :ivar event_id:
    :vartype event_id: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of event. Required. Known values are: \"session.update\",
     \"input_audio_buffer.append\", \"input_audio_buffer.commit\", \"input_audio_buffer.clear\",
     \"input_audio.turn.start\", \"input_audio.turn.append\", \"input_audio.turn.end\",
     \"input_audio.turn.cancel\", \"input_audio.clear\", \"conversation.item.create\",
     \"conversation.item.retrieve\", \"conversation.item.truncate\", \"conversation.item.delete\",
     \"response.create\", \"response.cancel\", and \"session.avatar.connect\"."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClientEventConversationItemCreate(ClientEvent, discriminator="conversation.item.create"):
    """Add a new Item to the Conversation's context, including messages, function
    calls, and function call responses. This event can be used both to populate a
    "history" of the conversation and to add new items mid-stream, but has the
    current limitation that it cannot populate assistant audio messages.

    If successful, the server will respond with a ``conversation.item.created``
    event, otherwise an ``error`` event will be sent.

    :ivar type: The event type, must be ``conversation.item.create``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_CREATE
    :ivar event_id: Optional client-generated ID used to identify this event.
    :vartype event_id: str
    :ivar previous_item_id: The ID of the preceding item after which the new item will be inserted.
     If not set, the new item will be appended to the end of the conversation.
     If set to ``root``, the new item will be added to the beginning of the conversation.
     If set to an existing ID, it allows an item to be inserted mid-conversation. If the
     ID cannot be found, an error will be returned and the item will not be added.
    :vartype previous_item_id: str
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ConversationRequestItem
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_CREATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.create``. Required."""
    previous_item_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the preceding item after which the new item will be inserted.
     If not set, the new item will be appended to the end of the conversation.
     If set to ``root``, the new item will be added to the beginning of the conversation.
     If set to an existing ID, it allows an item to be inserted mid-conversation. If the
     ID cannot be found, an error will be returned and the item will not be added."""
    item: Optional["_models.ConversationRequestItem"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        previous_item_id: Optional[str] = None,
        item: Optional["_models.ConversationRequestItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.CONVERSATION_ITEM_CREATE, **kwargs)


class ClientEventConversationItemDelete(ClientEvent, discriminator="conversation.item.delete"):
    """Send this event when you want to remove any item from the conversation
    history. The server will respond with a ``conversation.item.deleted`` event,
    unless the item does not exist in the conversation history, in which case the
    server will respond with an error.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.delete``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_DELETE
    :ivar item_id: The ID of the item to delete. Required.
    :vartype item_id: str
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_DELETE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.delete``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item to delete. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.CONVERSATION_ITEM_DELETE, **kwargs)


class ClientEventConversationItemRetrieve(ClientEvent, discriminator="conversation.item.retrieve"):
    """Send this event when you want to retrieve the server's representation of a specific item in the
    conversation history. This is useful, for example, to inspect user audio after noise
    cancellation and VAD.
    The server will respond with a ``conversation.item.retrieved`` event,
    unless the item does not exist in the conversation history, in which case the
    server will respond with an error.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.retrieve``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_RETRIEVE
    :ivar item_id: The ID of the item to retrieve. Required.
    :vartype item_id: str
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_RETRIEVE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.retrieve``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item to retrieve. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.CONVERSATION_ITEM_RETRIEVE, **kwargs)


class ClientEventConversationItemTruncate(ClientEvent, discriminator="conversation.item.truncate"):
    """Send this event to truncate a previous assistant message’s audio. The server
    will produce audio faster than voicelive, so this event is useful when the user
    interrupts to truncate audio that has already been sent to the client but not
    yet played. This will synchronize the server's understanding of the audio with
    the client's playback.

    Truncating audio will delete the server-side text transcript to ensure there
    is not text in the context that hasn't been heard by the user.

    If successful, the server will respond with a ``conversation.item.truncated``
    event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.truncate``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_TRUNCATE
    :ivar item_id: The ID of the assistant message item to truncate. Only assistant message
     items can be truncated. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part to truncate. Set this to 0. Required.
    :vartype content_index: int
    :ivar audio_end_ms: Inclusive duration up to which audio is truncated, in milliseconds. If
     the audio_end_ms is greater than the actual audio duration, the server
     will respond with an error. Required.
    :vartype audio_end_ms: int
    """

    type: Literal[ClientEventType.CONVERSATION_ITEM_TRUNCATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.truncate``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the assistant message item to truncate. Only assistant message
     items can be truncated. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part to truncate. Set this to 0. Required."""
    audio_end_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Inclusive duration up to which audio is truncated, in milliseconds. If
     the audio_end_ms is greater than the actual audio duration, the server
     will respond with an error. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        audio_end_ms: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.CONVERSATION_ITEM_TRUNCATE, **kwargs)


class ClientEventInputAudioBufferAppend(ClientEvent, discriminator="input_audio_buffer.append"):
    """Send this event to append audio bytes to the input audio buffer. The audio
    buffer is temporary storage you can write to and later commit. In Server VAD
    mode, the audio buffer is used to detect speech and the server will decide
    when to commit. When Server VAD is disabled, you must commit the audio buffer
    manually.

    The client may choose how much audio to place in each event up to a maximum
    of 15 MiB, for example streaming smaller chunks from the client may allow the
    VAD to be more responsive. Unlike made other client events, the server will
    not send a confirmation response to this event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.append``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_APPEND
    :ivar audio: Base64-encoded audio. This must be in the format specified by the
     ``input_audio_format`` field in the session configuration. Required.
    :vartype audio: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_BUFFER_APPEND] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.append``. Required."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio. This must be in the format specified by the
     ``input_audio_format`` field in the session configuration. Required."""

    @overload
    def __init__(
        self,
        *,
        audio: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_BUFFER_APPEND, **kwargs)


class ClientEventInputAudioBufferClear(ClientEvent, discriminator="input_audio_buffer.clear"):
    """Send this event to clear the audio bytes in the buffer. The server will
    respond with an ``input_audio_buffer.cleared`` event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.clear``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_CLEAR
    """

    type: Literal[ClientEventType.INPUT_AUDIO_BUFFER_CLEAR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.clear``. Required."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_BUFFER_CLEAR, **kwargs)


class ClientEventInputAudioBufferCommit(ClientEvent, discriminator="input_audio_buffer.commit"):
    """Send this event to commit the user input audio buffer, which will create a
    new user message item in the conversation. This event will produce an error
    if the input audio buffer is empty. When in Server VAD mode, the client does
    not need to send this event, the server will commit the audio buffer
    automatically.

    Committing the input audio buffer will trigger input audio transcription
    (if enabled in session configuration), but it will not create a response
    from the model. The server will respond with an ``input_audio_buffer.committed``
    event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.commit``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_COMMIT
    """

    type: Literal[ClientEventType.INPUT_AUDIO_BUFFER_COMMIT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.commit``. Required."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_BUFFER_COMMIT, **kwargs)


class ClientEventInputAudioClear(ClientEvent, discriminator="input_audio.clear"):
    """Clears all input audio currently being streamed.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.clear'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_CLEAR
    """

    type: Literal[ClientEventType.INPUT_AUDIO_CLEAR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.clear'. Required."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_CLEAR, **kwargs)


class ClientEventInputAudioTurnAppend(ClientEvent, discriminator="input_audio.turn.append"):
    """Appends audio data to an ongoing input turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.append'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_APPEND
    :ivar turn_id: The ID of the turn this audio is part of. Required.
    :vartype turn_id: str
    :ivar audio: Base64-encoded audio chunk. Required.
    :vartype audio: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_APPEND] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.append'. Required."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the turn this audio is part of. Required."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio chunk. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        audio: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_TURN_APPEND, **kwargs)


class ClientEventInputAudioTurnCancel(ClientEvent, discriminator="input_audio.turn.cancel"):
    """Cancels an in-progress input audio turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.cancel'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_CANCEL
    :ivar turn_id: The ID of the turn to cancel. Required.
    :vartype turn_id: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_CANCEL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.cancel'. Required."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the turn to cancel. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_TURN_CANCEL, **kwargs)


class ClientEventInputAudioTurnEnd(ClientEvent, discriminator="input_audio.turn.end"):
    """Marks the end of an audio input turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.end'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_END
    :ivar turn_id: The ID of the audio turn being ended. Required.
    :vartype turn_id: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_END] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.end'. Required."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the audio turn being ended. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_TURN_END, **kwargs)


class ClientEventInputAudioTurnStart(ClientEvent, discriminator="input_audio.turn.start"):
    """Indicates the start of a new audio input turn.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'input_audio.turn.start'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_TURN_START
    :ivar turn_id: Unique identifier for the input audio turn. Required.
    :vartype turn_id: str
    """

    type: Literal[ClientEventType.INPUT_AUDIO_TURN_START] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'input_audio.turn.start'. Required."""
    turn_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the input audio turn. Required."""

    @overload
    def __init__(
        self,
        *,
        turn_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.INPUT_AUDIO_TURN_START, **kwargs)


class ClientEventResponseCancel(ClientEvent, discriminator="response.cancel"):
    """Send this event to cancel an in-progress response. The server will respond
    with a ``response.cancelled`` event or an error if there is no response to
    cancel.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.cancel``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CANCEL
    :ivar response_id: A specific response ID to cancel - if not provided, will cancel an
     in-progress response in the default conversation.
    :vartype response_id: str
    """

    type: Literal[ClientEventType.RESPONSE_CANCEL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.cancel``. Required."""
    response_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A specific response ID to cancel - if not provided, will cancel an
     in-progress response in the default conversation."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        response_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.RESPONSE_CANCEL, **kwargs)


class ClientEventResponseCreate(ClientEvent, discriminator="response.create"):
    """This event instructs the server to create a Response, which means triggering
    model inference. When in Server VAD mode, the server will create Responses
    automatically.

    A Response will include at least one Item, and may have two, in which case
    the second will be a function call. These Items will be appended to the
    conversation history.

    The server will respond with a ``response.created`` event, events for Items
    and content created, and finally a ``response.done`` event to indicate the
    Response is complete.

    The ``response.create`` event includes inference configuration like
    ``instructions``, and ``temperature``. These fields will override the Session's
    configuration for this Response only.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.create``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CREATE
    :ivar response:
    :vartype response: ~azure.ai.voicelive.models.ResponseCreateParams
    :ivar additional_instructions: additional instructions (system prompt) appended to the default
     instructions of the session. Only affects this response only.
    :vartype additional_instructions: str
    """

    type: Literal[ClientEventType.RESPONSE_CREATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.create``. Required."""
    response: Optional["_models.ResponseCreateParams"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    additional_instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """additional instructions (system prompt) appended to the default instructions of the session.
     Only affects this response only."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        response: Optional["_models.ResponseCreateParams"] = None,
        additional_instructions: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.RESPONSE_CREATE, **kwargs)


class ClientEventSessionAvatarConnect(ClientEvent, discriminator="session.avatar.connect"):
    """Sent when the client connects and provides its SDP (Session Description Protocol)
      for avatar-related media negotiation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'session.avatar.connect'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_AVATAR_CONNECT
    :ivar client_sdp: The client's SDP offer. Required.
    :vartype client_sdp: str
    """

    type: Literal[ClientEventType.SESSION_AVATAR_CONNECT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'session.avatar.connect'. Required."""
    client_sdp: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The client's SDP offer. Required."""

    @overload
    def __init__(
        self,
        *,
        client_sdp: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.SESSION_AVATAR_CONNECT, **kwargs)


class ClientEventSessionUpdate(ClientEvent, discriminator="session.update"):
    """Send this event to update the session’s default configuration.
    The client may send this event at any time to update any field,
    except for ``voice``. However, note that once a session has been
    initialized with a particular ``model``, it can’t be changed to
    another model using ``session.update``.

    When the server receives a ``session.update``, it will respond
    with a ``session.updated`` event showing the full, effective configuration.
    Only the fields that are present are updated. To clear a field like
    ``instructions``, pass an empty string.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``session.update``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_UPDATE
    :ivar session: Required.
    :vartype session: ~azure.ai.voicelive.models.RequestSession
    """

    type: Literal[ClientEventType.SESSION_UPDATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``session.update``. Required."""
    session: "_models.RequestSession" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        session: "_models.RequestSession",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ClientEventType.SESSION_UPDATE, **kwargs)


class ContentPart(_Model):
    """ContentPart.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseAudioContentPart, RequestAudioContentPart, RequestTextContentPart,
    ResponseTextContentPart

    :ivar type: Required. Known values are: "input_text", "input_audio", "text", and "audio".
    :vartype type: str or ~azure.ai.voicelive.models.ContentPartType
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"input_text\", \"input_audio\", \"text\", and \"audio\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EmotionCandidate(_Model):
    """EmotionCandidate.

    :ivar emotion: Required.
    :vartype emotion: str
    :ivar confidence: Required.
    :vartype confidence: float
    """

    emotion: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    confidence: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        emotion: str,
        confidence: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FunctionCallItem(ConversationRequestItem, discriminator="function_call"):
    """FunctionCallItem.

    :ivar id:
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL
    :ivar name: Required.
    :vartype name: str
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar arguments: Required.
    :vartype arguments: str
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    """

    type: Literal[ItemType.FUNCTION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Optional[Union[str, "_models.ItemParamStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"completed\" and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        call_id: str,
        arguments: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ItemType.FUNCTION_CALL, **kwargs)


class FunctionCallOutputItem(ConversationRequestItem, discriminator="function_call_output"):
    """FunctionCallOutputItem.

    :ivar id:
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL_OUTPUT
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar output: Required.
    :vartype output: str
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    """

    type: Literal[ItemType.FUNCTION_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Optional[Union[str, "_models.ItemParamStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"completed\" and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        output: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ItemType.FUNCTION_CALL_OUTPUT, **kwargs)


class Tool(_Model):
    """The base representation of a voicelive tool definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FunctionTool

    :ivar type: Required. "function"
    :vartype type: str or ~azure.ai.voicelive.models.ToolType
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. \"function\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FunctionTool(Tool, discriminator="function"):
    """The definition of a function tool as used by the voicelive endpoint.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION
    :ivar name: Required.
    :vartype name: str
    :ivar description:
    :vartype description: str
    :ivar parameters:
    :vartype parameters: any
    """

    type: Literal[ToolType.FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    parameters: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        parameters: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ToolType.FUNCTION, **kwargs)


class IceServer(_Model):
    """ICE server configuration for WebRTC connection negotiation.

    :ivar urls: List of ICE server URLs (e.g., TURN or STUN endpoints). Required.
    :vartype urls: list[str]
    :ivar username: Optional username used for authentication with the ICE server.
    :vartype username: str
    :ivar credential: Optional credential (e.g., password or token) used for authentication.
    :vartype credential: str
    """

    urls: List[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of ICE server URLs (e.g., TURN or STUN endpoints). Required."""
    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional username used for authentication with the ICE server."""
    credential: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional credential (e.g., password or token) used for authentication."""

    @overload
    def __init__(
        self,
        *,
        urls: List[str],
        username: Optional[str] = None,
        credential: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InputAudio(_Model):
    """Configuration for client audio input. Used to specify the audio model and optional phrase list.

    :ivar model: The name of the model to use for input audio (currently only 'azure-standard' is
     supported). Required. Default value is "azure-standard".
    :vartype model: str
    :ivar phrase_list: Optional list of phrases to bias the speech recognition engine.
    :vartype phrase_list: list[str]
    """

    model: Literal["azure-standard"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the model to use for input audio (currently only 'azure-standard' is supported).
     Required. Default value is \"azure-standard\"."""
    phrase_list: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional list of phrases to bias the speech recognition engine."""

    @overload
    def __init__(
        self,
        *,
        phrase_list: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.model: Literal["azure-standard"] = "azure-standard"


class UserContentPart(_Model):
    """UserContentPart.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InputAudioContentPart, InputTextContentPart

    :ivar type: Required. Default value is None.
    :vartype type: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InputAudioContentPart(UserContentPart, discriminator="input_audio"):
    """InputAudioContentPart.

    :ivar type: Required. Default value is "input_audio".
    :vartype type: str
    :ivar audio: Required.
    :vartype audio: str
    :ivar transcript:
    :vartype transcript: str
    """

    type: Literal["input_audio"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"input_audio\"."""
    audio: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    transcript: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        audio: str,
        transcript: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="input_audio", **kwargs)


class InputTextContentPart(UserContentPart, discriminator="input_text"):
    """InputTextContentPart.

    :ivar type: Required. Default value is "input_text".
    :vartype type: str
    :ivar text: Required.
    :vartype text: str
    """

    type: Literal["input_text"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"input_text\"."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="input_text", **kwargs)


class InputTokenDetails(_Model):
    """Details of input token usage.

    :ivar cached_tokens: Number of cached tokens used in the input. Required.
    :vartype cached_tokens: int
    :ivar text_tokens: Number of text tokens used in the input. Required.
    :vartype text_tokens: int
    :ivar audio_tokens: Number of audio tokens used in the input. Required.
    :vartype audio_tokens: int
    """

    cached_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of cached tokens used in the input. Required."""
    text_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of text tokens used in the input. Required."""
    audio_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of audio tokens used in the input. Required."""

    @overload
    def __init__(
        self,
        *,
        cached_tokens: int,
        text_tokens: int,
        audio_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LogProbProperties(_Model):
    """A single log probability entry for a token.

    :ivar token: The token that was used to generate the log probability. Required.
    :vartype token: str
    :ivar logprob: The log probability of the token. Required.
    :vartype logprob: float
    :ivar bytes: The bytes that were used to generate the log probability. Required.
    :vartype bytes: list[int]
    """

    token: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The token that was used to generate the log probability. Required."""
    logprob: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The log probability of the token. Required."""
    bytes: List[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The bytes that were used to generate the log probability. Required."""

    @overload
    def __init__(
        self,
        *,
        token: str,
        logprob: float,
        bytes: List[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NoTurnDetection(TurnDetection, discriminator="none"):
    """Disables turn detection.

    :ivar type: Required. Default value is "none".
    :vartype type: str
    """

    type: Literal["none"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"none\"."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="none", **kwargs)


class OpenAIVoice(_Model):
    """OpenAI voice configuration with explicit type field.

    This provides a unified interface for OpenAI voices, complementing the
    existing string-based OAIVoice for backward compatibility.

    :ivar type: Required. Default value is "openai".
    :vartype type: str
    :ivar name: Required. Known values are: "alloy", "ash", "ballad", "coral", "echo", "sage",
     "shimmer", and "verse".
    :vartype name: str or ~azure.ai.voicelive.models.OAIVoice
    """

    type: Literal["openai"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"openai\"."""
    name: Union[str, "_models.OAIVoice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"alloy\", \"ash\", \"ballad\", \"coral\", \"echo\", \"sage\",
     \"shimmer\", and \"verse\"."""

    @overload
    def __init__(
        self,
        *,
        name: Union[str, "_models.OAIVoice"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["openai"] = "openai"


class OutputTextContentPart(_Model):
    """Output text content part.

    :ivar type: Required. Default value is "text".
    :vartype type: str
    :ivar text: Required.
    :vartype text: str
    """

    type: Literal["text"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"text\"."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["text"] = "text"


class OutputTokenDetails(_Model):
    """Details of output token usage.

    :ivar text_tokens: Number of text tokens generated in the output. Required.
    :vartype text_tokens: int
    :ivar audio_tokens: Number of audio tokens generated in the output. Required.
    :vartype audio_tokens: int
    """

    text_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of text tokens generated in the output. Required."""
    audio_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of audio tokens generated in the output. Required."""

    @overload
    def __init__(
        self,
        *,
        text_tokens: int,
        audio_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestAudioContentPart(ContentPart, discriminator="input_audio"):
    """RequestAudioContentPart.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO
    :ivar transcript:
    :vartype transcript: str
    """

    type: Literal[ContentPartType.INPUT_AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    transcript: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        transcript: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ContentPartType.INPUT_AUDIO, **kwargs)


class RequestSession(_Model):
    """RequestSession.

    :ivar model:
    :vartype model: str
    :ivar modalities:
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar animation:
    :vartype animation: ~azure.ai.voicelive.models.Animation
    :ivar voice: Is one of the following types: Union[str, "_models.OAIVoice"], OpenAIVoice,
     AzureVoice, Union[str, "_models.Phi4mmVoice"]
    :vartype voice: str or ~azure.ai.voicelive.models.OAIVoice or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice or str or
     ~azure.ai.voicelive.models.Phi4mmVoice
    :ivar instructions:
    :vartype instructions: str
    :ivar input_audio:
    :vartype input_audio: ~azure.ai.voicelive.models.InputAudio
    :ivar input_audio_sampling_rate:
    :vartype input_audio_sampling_rate: int
    :ivar input_audio_format: Known values are: "pcm16", "g711_ulaw", and "g711_alaw".
    :vartype input_audio_format: str or ~azure.ai.voicelive.models.AudioFormat
    :ivar output_audio_format: Known values are: "pcm16", "g711_ulaw", and "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.AudioFormat
    :ivar turn_detection:
    :vartype turn_detection: ~azure.ai.voicelive.models.TurnDetection
    :ivar input_audio_noise_reduction:
    :vartype input_audio_noise_reduction: ~azure.ai.voicelive.models.AudioNoiseReduction
    :ivar input_audio_echo_cancellation:
    :vartype input_audio_echo_cancellation: ~azure.ai.voicelive.models.AudioEchoCancellation
    :ivar avatar:
    :vartype avatar: ~azure.ai.voicelive.models.AvatarConfig
    :ivar input_audio_transcription:
    :vartype input_audio_transcription: ~azure.ai.voicelive.models.AudioInputTranscriptionSettings
    :ivar output_audio_timestamp_types:
    :vartype output_audio_timestamp_types: list[str or
     ~azure.ai.voicelive.models.AudioTimestampType]
    :ivar tools:
    :vartype tools: list[~azure.ai.voicelive.models.Tool]
    :ivar tool_choice: Is either a Union[str, "_models.ToolChoiceLiteral"] type or a
     ToolChoiceObject type.
    :vartype tool_choice: str or ~azure.ai.voicelive.models.ToolChoiceLiteral or
     ~azure.ai.voicelive.models.ToolChoiceObject
    :ivar temperature:
    :vartype temperature: float
    :ivar max_response_output_tokens: Is either a int type or a Literal["inf"] type.
    :vartype max_response_output_tokens: int or str
    """

    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    modalities: Optional[List[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    animation: Optional["_models.Animation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Is one of the following types: Union[str, \"_models.OAIVoice\"], OpenAIVoice, AzureVoice,
     Union[str, \"_models.Phi4mmVoice\"]"""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    input_audio: Optional["_models.InputAudio"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    input_audio_sampling_rate: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    input_audio_format: Optional[Union[str, "_models.AudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"pcm16\", \"g711_ulaw\", and \"g711_alaw\"."""
    output_audio_format: Optional[Union[str, "_models.AudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"pcm16\", \"g711_ulaw\", and \"g711_alaw\"."""
    turn_detection: Optional["_models.TurnDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    avatar: Optional["_models.AvatarConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    input_audio_transcription: Optional["_models.AudioInputTranscriptionSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    output_audio_timestamp_types: Optional[List[Union[str, "_models.AudioTimestampType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    tools: Optional[List["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    tool_choice: Optional["_types.ToolChoice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Is either a Union[str, \"_models.ToolChoiceLiteral\"] type or a ToolChoiceObject type."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Is either a int type or a Literal[\"inf\"] type."""

    @overload
    def __init__(
        self,
        *,
        model: Optional[str] = None,
        modalities: Optional[List[Union[str, "_models.Modality"]]] = None,
        animation: Optional["_models.Animation"] = None,
        voice: Optional["_types.Voice"] = None,
        instructions: Optional[str] = None,
        input_audio: Optional["_models.InputAudio"] = None,
        input_audio_sampling_rate: Optional[int] = None,
        input_audio_format: Optional[Union[str, "_models.AudioFormat"]] = None,
        output_audio_format: Optional[Union[str, "_models.AudioFormat"]] = None,
        turn_detection: Optional["_models.TurnDetection"] = None,
        input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = None,
        input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = None,
        avatar: Optional["_models.AvatarConfig"] = None,
        input_audio_transcription: Optional["_models.AudioInputTranscriptionSettings"] = None,
        output_audio_timestamp_types: Optional[List[Union[str, "_models.AudioTimestampType"]]] = None,
        tools: Optional[List["_models.Tool"]] = None,
        tool_choice: Optional["_types.ToolChoice"] = None,
        temperature: Optional[float] = None,
        max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestTextContentPart(ContentPart, discriminator="input_text"):
    """RequestTextContentPart.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_TEXT
    :ivar text:
    :vartype text: str
    """

    type: Literal[ContentPartType.INPUT_TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ContentPartType.INPUT_TEXT, **kwargs)


class Response(_Model):
    """The response resource.

    :ivar id: The unique ID of the response.
    :vartype id: str
    :ivar object: The object type, must be ``realtime.response``. Default value is
     "realtime.response".
    :vartype object: str
    :ivar status: The final status of the response.
     One of: ``completed``, ``cancelled``, ``failed``, ``incomplete``, or ``in_progress``. Known
     values are: "completed", "cancelled", "failed", "incomplete", and "in_progress".
    :vartype status: str or ~azure.ai.voicelive.models.ResponseStatus
    :ivar status_details: Additional details about the status.
    :vartype status_details: ~azure.ai.voicelive.models.ResponseStatusDetails
    :ivar output: The list of output items generated by the response.
    :vartype output: list[~azure.ai.voicelive.models.ResponseItem]
    :ivar usage: Usage statistics for the Response, this will correspond to billing. A
     VoiceLive API session will maintain a conversation context and append new
     Items to the Conversation, thus output from previous turns (text and
     audio tokens) will become the input for later turns.
    :vartype usage: ~azure.ai.voicelive.models.Usage
    :ivar conversation_id: Which conversation the response is added to, determined by the
     ``conversation``
     field in the ``response.create`` event. If ``auto``, the response will be added to
     the default conversation and the value of ``conversation_id`` will be an id like
     ``conv_1234``. If ``none``, the response will not be added to any conversation and
     the value of ``conversation_id`` will be ``null``. If responses are being triggered
     by server VAD, the response will be added to the default conversation, thus
     the ``conversation_id`` will be an id like ``conv_1234``.
    :vartype conversation_id: str
    :ivar voice: supported voice identifiers and configurations. Is one of the following types:
     Union[str, "_models.OAIVoice"], OpenAIVoice, AzureVoice, Union[str, "_models.Phi4mmVoice"]
    :vartype voice: str or ~azure.ai.voicelive.models.OAIVoice or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice or str or
     ~azure.ai.voicelive.models.Phi4mmVoice
    :ivar modalities: The set of modalities the model used to respond. If there are multiple
     modalities,
     the model will pick one, for example if ``modalities`` is ``["text", "audio"]``, the model
     could be responding in either text or audio.
    :vartype modalities: list[str]
    :ivar output_audio_format: The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or
     ``g711_alaw``. Is one of the following types: Literal["pcm16"], Literal["g711_ulaw"],
     Literal["g711_alaw"]
    :vartype output_audio_format: str
    :ivar temperature: Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.
    :vartype temperature: float
    :ivar max_output_tokens: Maximum number of output tokens for a single assistant response,
     inclusive of tool calls, that was used in this response. Is either a int type or a
     Literal["inf"] type.
    :vartype max_output_tokens: int or str
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the response."""
    object: Optional[Literal["realtime.response"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The object type, must be ``realtime.response``. Default value is \"realtime.response\"."""
    status: Optional[Union[str, "_models.ResponseStatus"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The final status of the response.
     One of: ``completed``, ``cancelled``, ``failed``, ``incomplete``, or ``in_progress``. Known
     values are: \"completed\", \"cancelled\", \"failed\", \"incomplete\", and \"in_progress\"."""
    status_details: Optional["_models.ResponseStatusDetails"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Additional details about the status."""
    output: Optional[List["_models.ResponseItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The list of output items generated by the response."""
    usage: Optional["_models.Usage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usage statistics for the Response, this will correspond to billing. A
     VoiceLive API session will maintain a conversation context and append new
     Items to the Conversation, thus output from previous turns (text and
     audio tokens) will become the input for later turns."""
    conversation_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Which conversation the response is added to, determined by the ``conversation``
     field in the ``response.create`` event. If ``auto``, the response will be added to
     the default conversation and the value of ``conversation_id`` will be an id like
     ``conv_1234``. If ``none``, the response will not be added to any conversation and
     the value of ``conversation_id`` will be ``null``. If responses are being triggered
     by server VAD, the response will be added to the default conversation, thus
     the ``conversation_id`` will be an id like ``conv_1234``."""
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """supported voice identifiers and configurations. Is one of the following types: Union[str,
     \"_models.OAIVoice\"], OpenAIVoice, AzureVoice, Union[str, \"_models.Phi4mmVoice\"]"""
    modalities: Optional[List[Literal["text", "audio"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of modalities the model used to respond. If there are multiple modalities,
     the model will pick one, for example if ``modalities`` is ``[\"text\", \"audio\"]``, the model
     could be responding in either text or audio."""
    output_audio_format: Optional[Literal["pcm16", "g711_ulaw", "g711_alaw"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or ``g711_alaw``. Is one of
     the following types: Literal[\"pcm16\"], Literal[\"g711_ulaw\"], Literal[\"g711_alaw\"]"""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8."""
    max_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of output tokens for a single assistant response,
     inclusive of tool calls, that was used in this response. Is either a int type or a
     Literal[\"inf\"] type."""

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.response"]] = None,
        status: Optional[Union[str, "_models.ResponseStatus"]] = None,
        status_details: Optional["_models.ResponseStatusDetails"] = None,
        output: Optional[List["_models.ResponseItem"]] = None,
        usage: Optional["_models.Usage"] = None,
        conversation_id: Optional[str] = None,
        voice: Optional["_types.Voice"] = None,
        modalities: Optional[List[Literal["text", "audio"]]] = None,
        output_audio_format: Optional[Literal["pcm16", "g711_ulaw", "g711_alaw"]] = None,
        temperature: Optional[float] = None,
        max_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseAudioContentPart(ContentPart, discriminator="audio"):
    """ResponseAudioContentPart.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.AUDIO
    :ivar transcript:
    :vartype transcript: str
    """

    type: Literal[ContentPartType.AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    transcript: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        transcript: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ContentPartType.AUDIO, **kwargs)


class ResponseStatusDetails(_Model):
    """Base for all non-success response details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseCancelledDetails, ResponseFailedDetails, ResponseIncompleteDetails

    :ivar type: Required. Default value is None.
    :vartype type: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseCancelledDetails(ResponseStatusDetails, discriminator="cancelled"):
    """Details for a cancelled response.

    :ivar type: Required. Default value is "cancelled".
    :vartype type: str
    :ivar reason: Required. Is either a Literal["turn_detected"] type or a
     Literal["client_cancelled"] type.
    :vartype reason: str
    """

    type: Literal["cancelled"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"cancelled\"."""
    reason: Literal["turn_detected", "client_cancelled"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is either a Literal[\"turn_detected\"] type or a Literal[\"client_cancelled\"] type."""

    @overload
    def __init__(
        self,
        *,
        reason: Literal["turn_detected", "client_cancelled"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="cancelled", **kwargs)


class ResponseCreateParams(_Model):
    """Create a new VoiceLive response with these parameters.

    :ivar commit: Whether to commit the response to the conversation. Defaults to true.
    :vartype commit: bool
    :ivar cancel_previous: Whether to cancel any ongoing generation before starting this one.
     Defaults to true.
    :vartype cancel_previous: bool
    :ivar append_input_items: Input items to append to the conversation context before generating a
     response.
    :vartype append_input_items: list[~azure.ai.voicelive.models.ConversationRequestItem]
    :ivar input_items: Input items to be used as the context for this response.
     An empty array clears previous context.
    :vartype input_items: list[~azure.ai.voicelive.models.ConversationRequestItem]
    :ivar modalities: The set of modalities the model can respond with. To disable audio,
     set this to ["text"].
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar instructions: The default system instructions (i.e. system message) prepended to model
     calls. This field allows the client to guide the model on desired
     responses. The model can be instructed on response content and format,
     (e.g. "be extremely succinct", "act friendly", "here are examples of good
     responses") and on audio behavior (e.g. "talk quickly", "inject emotion
     into your voice", "laugh frequently"). The instructions are not guaranteed
     to be followed by the model, but they provide guidance to the model on the
     desired behavior.

     Note that the server sets default instructions which will be used if this
     field is not set and are visible in the ``session.created`` event at the
     start of the session.
    :vartype instructions: str
    :ivar voice: supported voice identifiers and configurations. Is one of the following types:
     Union[str, "_models.OAIVoice"], OpenAIVoice, AzureVoice, Union[str, "_models.Phi4mmVoice"]
    :vartype voice: str or ~azure.ai.voicelive.models.OAIVoice or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice or str or
     ~azure.ai.voicelive.models.Phi4mmVoice
    :ivar output_audio_format: The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or
     ``g711_alaw``. Known values are: "pcm16", "g711_ulaw", and "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.AudioFormat
    :ivar tools: Tools (functions) available to the model.
    :vartype tools: list[~azure.ai.voicelive.models.Tool]
    :ivar tool_choice: How the model chooses tools. Options are ``auto``, ``none``, ``required``,
     or
     specify a function, like ``{"type": "function", "function": {"name": "my_function"}}``.
    :vartype tool_choice: str
    :ivar temperature: Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8.
    :vartype temperature: float
    :ivar max_output_tokens: Maximum number of output tokens for a single assistant response,
     inclusive of tool calls. Provide an integer between 1 and 4096 to
     limit output tokens, or ``inf`` for the maximum available tokens for a
     given model. Defaults to ``inf``. Is either a int type or a Literal["inf"] type.
    :vartype max_output_tokens: int or str
    """

    commit: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to commit the response to the conversation. Defaults to true."""
    cancel_previous: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to cancel any ongoing generation before starting this one. Defaults to true."""
    append_input_items: Optional[List["_models.ConversationRequestItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input items to append to the conversation context before generating a response."""
    input_items: Optional[List["_models.ConversationRequestItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input items to be used as the context for this response.
     An empty array clears previous context."""
    modalities: Optional[List[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The set of modalities the model can respond with. To disable audio,
     set this to [\"text\"]."""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The default system instructions (i.e. system message) prepended to model
     calls. This field allows the client to guide the model on desired
     responses. The model can be instructed on response content and format,
     (e.g. \"be extremely succinct\", \"act friendly\", \"here are examples of good
     responses\") and on audio behavior (e.g. \"talk quickly\", \"inject emotion
     into your voice\", \"laugh frequently\"). The instructions are not guaranteed
     to be followed by the model, but they provide guidance to the model on the
     desired behavior.
     
     Note that the server sets default instructions which will be used if this
     field is not set and are visible in the ``session.created`` event at the
     start of the session."""
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """supported voice identifiers and configurations. Is one of the following types: Union[str,
     \"_models.OAIVoice\"], OpenAIVoice, AzureVoice, Union[str, \"_models.Phi4mmVoice\"]"""
    output_audio_format: Optional[Union[str, "_models.AudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The format of output audio. Options are ``pcm16``, ``g711_ulaw``, or ``g711_alaw``. Known
     values are: \"pcm16\", \"g711_ulaw\", and \"g711_alaw\"."""
    tools: Optional[List["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Tools (functions) available to the model."""
    tool_choice: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """How the model chooses tools. Options are ``auto``, ``none``, ``required``, or
     specify a function, like ``{\"type\": \"function\", \"function\": {\"name\":
     \"my_function\"}}``."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sampling temperature for the model, limited to [0.6, 1.2]. Defaults to 0.8."""
    max_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of output tokens for a single assistant response,
     inclusive of tool calls. Provide an integer between 1 and 4096 to
     limit output tokens, or ``inf`` for the maximum available tokens for a
     given model. Defaults to ``inf``. Is either a int type or a Literal[\"inf\"] type."""

    @overload
    def __init__(
        self,
        *,
        commit: Optional[bool] = None,
        cancel_previous: Optional[bool] = None,
        append_input_items: Optional[List["_models.ConversationRequestItem"]] = None,
        input_items: Optional[List["_models.ConversationRequestItem"]] = None,
        modalities: Optional[List[Union[str, "_models.Modality"]]] = None,
        instructions: Optional[str] = None,
        voice: Optional["_types.Voice"] = None,
        output_audio_format: Optional[Union[str, "_models.AudioFormat"]] = None,
        tools: Optional[List["_models.Tool"]] = None,
        tool_choice: Optional[str] = None,
        temperature: Optional[float] = None,
        max_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseFailedDetails(ResponseStatusDetails, discriminator="failed"):
    """Details for a failed response.

    :ivar type: Required. Default value is "failed".
    :vartype type: str
    :ivar error: Required.
    :vartype error: any
    """

    type: Literal["failed"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"failed\"."""
    error: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        error: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="failed", **kwargs)


class ResponseItem(_Model):
    """ResponseItem.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseFunctionCallItem, ResponseFunctionCallOutputItem, ResponseMessageItem

    :ivar type: Required. Known values are: "message", "function_call", and "function_call_output".
    :vartype type: str or ~azure.ai.voicelive.models.ItemType
    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"message\", \"function_call\", and \"function_call_output\"."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    object: Optional[Literal["realtime.item"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Default value is \"realtime.item\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseFunctionCallItem(ResponseItem, discriminator="function_call"):
    """ResponseFunctionCallItem.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL
    :ivar name: Required.
    :vartype name: str
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar arguments: Required.
    :vartype arguments: str
    :ivar status: Required. Known values are: "in_progress", "completed", and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ResponseItemStatus
    """

    type: Literal[ItemType.FUNCTION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Union[str, "_models.ResponseItemStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"in_progress\", \"completed\", and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        call_id: str,
        arguments: str,
        status: Union[str, "_models.ResponseItemStatus"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ItemType.FUNCTION_CALL, **kwargs)


class ResponseFunctionCallOutputItem(ResponseItem, discriminator="function_call_output"):
    """ResponseFunctionCallOutputItem.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION_CALL_OUTPUT
    :ivar call_id: Required.
    :vartype call_id: str
    :ivar output: Required.
    :vartype output: str
    """

    type: Literal[ItemType.FUNCTION_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        output: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ItemType.FUNCTION_CALL_OUTPUT, **kwargs)


class ResponseIncompleteDetails(ResponseStatusDetails, discriminator="incomplete"):
    """Details for an incomplete response.

    :ivar type: Required. Default value is "incomplete".
    :vartype type: str
    :ivar reason: Required. Is either a Literal["max_output_tokens"] type or a
     Literal["content_filter"] type.
    :vartype reason: str
    """

    type: Literal["incomplete"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"incomplete\"."""
    reason: Literal["max_output_tokens", "content_filter"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is either a Literal[\"max_output_tokens\"] type or a Literal[\"content_filter\"]
     type."""

    @overload
    def __init__(
        self,
        *,
        reason: Literal["max_output_tokens", "content_filter"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="incomplete", **kwargs)


class ResponseMessageItem(ResponseItem, discriminator="message"):
    """ResponseMessageItem.

    :ivar id:
    :vartype id: str
    :ivar object: Default value is "realtime.item".
    :vartype object: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar role: Required. Known values are: "system", "user", and "assistant".
    :vartype role: str or ~azure.ai.voicelive.models.MessageRole
    :ivar content: Required.
    :vartype content: list[~azure.ai.voicelive.models.ContentPart]
    :ivar status: Required. Known values are: "in_progress", "completed", and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ResponseItemStatus
    """

    type: Literal[ItemType.MESSAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    role: Union[str, "_models.MessageRole"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"system\", \"user\", and \"assistant\"."""
    content: List["_models.ContentPart"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    status: Union[str, "_models.ResponseItemStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"in_progress\", \"completed\", and \"incomplete\"."""

    @overload
    def __init__(
        self,
        *,
        role: Union[str, "_models.MessageRole"],
        content: List["_models.ContentPart"],
        status: Union[str, "_models.ResponseItemStatus"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        object: Optional[Literal["realtime.item"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ItemType.MESSAGE, **kwargs)


class ResponseSession(_Model):
    """ResponseSession.

    :ivar id:
    :vartype id: str
    :ivar model:
    :vartype model: str
    :ivar modalities:
    :vartype modalities: list[str or ~azure.ai.voicelive.models.Modality]
    :ivar instructions:
    :vartype instructions: str
    :ivar animation:
    :vartype animation: ~azure.ai.voicelive.models.Animation
    :ivar voice: Is one of the following types: Union[str, "_models.OAIVoice"], OpenAIVoice,
     AzureVoice, Union[str, "_models.Phi4mmVoice"]
    :vartype voice: str or ~azure.ai.voicelive.models.OAIVoice or
     ~azure.ai.voicelive.models.OpenAIVoice or ~azure.ai.voicelive.models.AzureVoice or str or
     ~azure.ai.voicelive.models.Phi4mmVoice
    :ivar input_audio:
    :vartype input_audio: ~azure.ai.voicelive.models.InputAudio
    :ivar input_audio_format: Known values are: "pcm16", "g711_ulaw", and "g711_alaw".
    :vartype input_audio_format: str or ~azure.ai.voicelive.models.AudioFormat
    :ivar output_audio_format: Known values are: "pcm16", "g711_ulaw", and "g711_alaw".
    :vartype output_audio_format: str or ~azure.ai.voicelive.models.AudioFormat
    :ivar input_audio_sampling_rate:
    :vartype input_audio_sampling_rate: int
    :ivar turn_detection:
    :vartype turn_detection: ~azure.ai.voicelive.models.TurnDetection
    :ivar input_audio_noise_reduction:
    :vartype input_audio_noise_reduction: ~azure.ai.voicelive.models.AudioNoiseReduction
    :ivar input_audio_echo_cancellation:
    :vartype input_audio_echo_cancellation: ~azure.ai.voicelive.models.AudioEchoCancellation
    :ivar avatar:
    :vartype avatar: ~azure.ai.voicelive.models.AvatarConfig
    :ivar input_audio_transcription:
    :vartype input_audio_transcription: ~azure.ai.voicelive.models.AudioInputTranscriptionSettings
    :ivar output_audio_timestamp_types:
    :vartype output_audio_timestamp_types: list[str or
     ~azure.ai.voicelive.models.AudioTimestampType]
    :ivar tools:
    :vartype tools: list[~azure.ai.voicelive.models.Tool]
    :ivar tool_choice: Is either a Union[str, "_models.ToolChoiceLiteral"] type or a
     ToolChoiceObject type.
    :vartype tool_choice: str or ~azure.ai.voicelive.models.ToolChoiceLiteral or
     ~azure.ai.voicelive.models.ToolChoiceObject
    :ivar temperature:
    :vartype temperature: float
    :ivar max_response_output_tokens: Is either a int type or a Literal["inf"] type.
    :vartype max_response_output_tokens: int or str
    :ivar agent:
    :vartype agent: ~azure.ai.voicelive.models.AgentConfig
    """

    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    modalities: Optional[List[Union[str, "_models.Modality"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    animation: Optional["_models.Animation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    voice: Optional["_types.Voice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Is one of the following types: Union[str, \"_models.OAIVoice\"], OpenAIVoice, AzureVoice,
     Union[str, \"_models.Phi4mmVoice\"]"""
    input_audio: Optional["_models.InputAudio"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    input_audio_format: Optional[Union[str, "_models.AudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"pcm16\", \"g711_ulaw\", and \"g711_alaw\"."""
    output_audio_format: Optional[Union[str, "_models.AudioFormat"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"pcm16\", \"g711_ulaw\", and \"g711_alaw\"."""
    input_audio_sampling_rate: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    turn_detection: Optional["_models.TurnDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    avatar: Optional["_models.AvatarConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    input_audio_transcription: Optional["_models.AudioInputTranscriptionSettings"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    output_audio_timestamp_types: Optional[List[Union[str, "_models.AudioTimestampType"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    tools: Optional[List["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    tool_choice: Optional["_types.ToolChoice"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Is either a Union[str, \"_models.ToolChoiceLiteral\"] type or a ToolChoiceObject type."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Is either a int type or a Literal[\"inf\"] type."""
    agent: Optional["_models.AgentConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        model: Optional[str] = None,
        modalities: Optional[List[Union[str, "_models.Modality"]]] = None,
        instructions: Optional[str] = None,
        animation: Optional["_models.Animation"] = None,
        voice: Optional["_types.Voice"] = None,
        input_audio: Optional["_models.InputAudio"] = None,
        input_audio_format: Optional[Union[str, "_models.AudioFormat"]] = None,
        output_audio_format: Optional[Union[str, "_models.AudioFormat"]] = None,
        input_audio_sampling_rate: Optional[int] = None,
        turn_detection: Optional["_models.TurnDetection"] = None,
        input_audio_noise_reduction: Optional["_models.AudioNoiseReduction"] = None,
        input_audio_echo_cancellation: Optional["_models.AudioEchoCancellation"] = None,
        avatar: Optional["_models.AvatarConfig"] = None,
        input_audio_transcription: Optional["_models.AudioInputTranscriptionSettings"] = None,
        output_audio_timestamp_types: Optional[List[Union[str, "_models.AudioTimestampType"]]] = None,
        tools: Optional[List["_models.Tool"]] = None,
        tool_choice: Optional["_types.ToolChoice"] = None,
        temperature: Optional[float] = None,
        max_response_output_tokens: Optional[Union[int, Literal["inf"]]] = None,
        agent: Optional["_models.AgentConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseTextContentPart(ContentPart, discriminator="text"):
    """ResponseTextContentPart.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.TEXT
    :ivar text:
    :vartype text: str
    """

    type: Literal[ContentPartType.TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        text: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ContentPartType.TEXT, **kwargs)


class ServerEvent(_Model):
    """A voicelive server event.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ServerEventConversationItemCreated, ServerEventConversationItemDeleted,
    ServerEventConversationItemInputAudioTranscriptionCompleted,
    ServerEventConversationItemInputAudioTranscriptionDelta,
    ServerEventConversationItemInputAudioTranscriptionFailed, ServerEventConversationItemRetrieved,
    ServerEventConversationItemTruncated, ServerEventError, ServerEventInputAudioBufferCleared,
    ServerEventInputAudioBufferCommitted, ServerEventInputAudioBufferSpeechStarted,
    ServerEventInputAudioBufferSpeechStopped, ServerEventResponseAnimationBlendshapeDelta,
    ServerEventResponseAnimationBlendshapeDone, ServerEventResponseAnimationVisemeDelta,
    ServerEventResponseAnimationVisemeDone, ServerEventResponseAudioDelta,
    ServerEventResponseAudioDone, ServerEventResponseAudioTimestampDelta,
    ServerEventResponseAudioTimestampDone, ServerEventResponseAudioTranscriptDelta,
    ServerEventResponseAudioTranscriptDone, ServerEventResponseContentPartAdded,
    ServerEventResponseContentPartDone, ServerEventResponseCreated, ServerEventResponseDone,
    ServerEventResponseEmotionHypothesis, ServerEventResponseFunctionCallArgumentsDelta,
    ServerEventResponseFunctionCallArgumentsDone, ServerEventResponseOutputItemAdded,
    ServerEventResponseOutputItemDone, ServerEventResponseTextDelta, ServerEventResponseTextDone,
    ServerEventSessionAvatarConnecting, ServerEventSessionCreated, ServerEventSessionUpdated

    :ivar type: The type of event. Required. Known values are: "error",
     "session.avatar.connecting", "session.created", "session.updated",
     "conversation.item.input_audio_transcription.completed",
     "conversation.item.input_audio_transcription.delta",
     "conversation.item.input_audio_transcription.failed", "conversation.item.created",
     "conversation.item.retrieved", "conversation.item.truncated", "conversation.item.deleted",
     "input_audio_buffer.committed", "input_audio_buffer.cleared",
     "input_audio_buffer.speech_started", "input_audio_buffer.speech_stopped", "response.created",
     "response.done", "response.output_item.added", "response.output_item.done",
     "response.content_part.added", "response.content_part.done", "response.text.delta",
     "response.text.done", "response.audio_transcript.delta", "response.audio_transcript.done",
     "response.audio.delta", "response.audio.done", "response.animation_blendshapes.delta",
     "response.animation_blendshapes.done", "response.emotion_hypothesis",
     "response.audio_timestamp.delta", "response.audio_timestamp.done",
     "response.animation_viseme.delta", "response.animation_viseme.done",
     "response.function_call_arguments.delta", and "response.function_call_arguments.done".
    :vartype type: str or ~azure.ai.voicelive.models.ServerEventType
    :ivar event_id:
    :vartype event_id: str
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of event. Required. Known values are: \"error\", \"session.avatar.connecting\",
     \"session.created\", \"session.updated\",
     \"conversation.item.input_audio_transcription.completed\",
     \"conversation.item.input_audio_transcription.delta\",
     \"conversation.item.input_audio_transcription.failed\", \"conversation.item.created\",
     \"conversation.item.retrieved\", \"conversation.item.truncated\",
     \"conversation.item.deleted\", \"input_audio_buffer.committed\",
     \"input_audio_buffer.cleared\", \"input_audio_buffer.speech_started\",
     \"input_audio_buffer.speech_stopped\", \"response.created\", \"response.done\",
     \"response.output_item.added\", \"response.output_item.done\", \"response.content_part.added\",
     \"response.content_part.done\", \"response.text.delta\", \"response.text.done\",
     \"response.audio_transcript.delta\", \"response.audio_transcript.done\",
     \"response.audio.delta\", \"response.audio.done\", \"response.animation_blendshapes.delta\",
     \"response.animation_blendshapes.done\", \"response.emotion_hypothesis\",
     \"response.audio_timestamp.delta\", \"response.audio_timestamp.done\",
     \"response.animation_viseme.delta\", \"response.animation_viseme.done\",
     \"response.function_call_arguments.delta\", and \"response.function_call_arguments.done\"."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        type: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)

    @classmethod
    def deserialize(cls, payload: dict) -> "ServerEvent":
        # public, linter-friendly entrypoint
        # pylint: disable-next=protected-access
        return cls._deserialize(payload, [])


class ServerEventConversationItemCreated(ServerEvent, discriminator="conversation.item.created"):
    """Returned when a conversation item is created. There are several scenarios that produce this
    event:

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.created``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_CREATED
    :ivar previous_item_id: The ID of the preceding item in the Conversation context, allows the
     client to understand the order of the conversation.
    :vartype previous_item_id: str
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.created``. Required."""
    previous_item_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the preceding item in the Conversation context, allows the
     client to understand the order of the conversation."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
        previous_item_id: Optional[str] = None,
        item: Optional["_models.ResponseItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_CREATED, **kwargs)


class ServerEventConversationItemDeleted(ServerEvent, discriminator="conversation.item.deleted"):
    """Returned when an item in the conversation is deleted by the client with a
    ``conversation.item.delete`` event. This event is used to synchronize the
    server's understanding of the conversation history with the client's view.

    :ivar type: The event type, must be ``conversation.item.deleted``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_DELETED
    :ivar item_id: The ID of the item that was deleted. Required.
    :vartype item_id: str
    :ivar event_id:
    :vartype event_id: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_DELETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.deleted``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item that was deleted. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_DELETED, **kwargs)


class ServerEventConversationItemInputAudioTranscriptionCompleted(
    ServerEvent, discriminator="conversation.item.input_audio_transcription.completed"
):  # pylint: disable=name-too-long
    """This event is the output of audio transcription for user audio written to the
    user audio buffer. Transcription begins when the input audio buffer is
    committed by the client or server (in ``server_vad`` mode). Transcription runs
    asynchronously with Response creation, so this event may come before or after
    the Response events.

    VoiceLive API models accept audio natively, and thus input transcription is a
    separate process run on a separate ASR (Automatic Speech Recognition) model.
    The transcript may diverge somewhat from the model's interpretation, and
    should be treated as a rough guide.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be
     ``conversation.item.input_audio_transcription.completed``. Required.
    :vartype type: str or
     ~azure.ai.voicelive.models.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED
    :ivar item_id: The ID of the user message item containing the audio. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part containing the audio. Required.
    :vartype content_index: int
    :ivar transcript: The transcribed text. Required.
    :vartype transcript: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be
     ``conversation.item.input_audio_transcription.completed``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item containing the audio. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part containing the audio. Required."""
    transcript: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The transcribed text. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        transcript: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_COMPLETED, **kwargs)


class ServerEventConversationItemInputAudioTranscriptionDelta(
    ServerEvent, discriminator="conversation.item.input_audio_transcription.delta"
):  # pylint: disable=name-too-long
    """Returned when the text value of an input audio transcription content part is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``conversation.item.input_audio_transcription.delta``.
     Required.
    :vartype type: str or
     ~azure.ai.voicelive.models.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part in the item's content array.
    :vartype content_index: int
    :ivar delta: The text delta.
    :vartype delta: str
    :ivar logprobs: The log probabilities of the transcription.
    :vartype logprobs: list[~azure.ai.voicelive.models.LogProbProperties]
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.input_audio_transcription.delta``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    content_index: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array."""
    delta: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text delta."""
    logprobs: Optional[List["_models.LogProbProperties"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The log probabilities of the transcription."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
        content_index: Optional[int] = None,
        delta: Optional[str] = None,
        logprobs: Optional[List["_models.LogProbProperties"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_DELTA, **kwargs)


class ServerEventConversationItemInputAudioTranscriptionFailed(
    ServerEvent, discriminator="conversation.item.input_audio_transcription.failed"
):  # pylint: disable=name-too-long
    """Returned when input audio transcription is configured, and a transcription
    request for a user message failed. These events are separate from other
    ``error`` events so that the client can identify the related Item.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be
     ``conversation.item.input_audio_transcription.failed``. Required.
    :vartype type: str or
     ~azure.ai.voicelive.models.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED
    :ivar item_id: The ID of the user message item. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part containing the audio. Required.
    :vartype content_index: int
    :ivar error: Details of the transcription error. Required.
    :vartype error: ~azure.ai.voicelive.models.VoiceLiveErrorDetails
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be
     ``conversation.item.input_audio_transcription.failed``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part containing the audio. Required."""
    error: "_models.VoiceLiveErrorDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the transcription error. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        error: "_models.VoiceLiveErrorDetails",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_INPUT_AUDIO_TRANSCRIPTION_FAILED, **kwargs)


class ServerEventConversationItemRetrieved(ServerEvent, discriminator="conversation.item.retrieved"):
    """Returned when a conversation item is retrieved with ``conversation.item.retrieve``.

    :ivar type: The event type, must be ``conversation.item.retrieved``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_RETRIEVED
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    :ivar event_id:
    :vartype event_id: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_RETRIEVED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.retrieved``. Required."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        item: Optional["_models.ResponseItem"] = None,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_RETRIEVED, **kwargs)


class ServerEventConversationItemTruncated(ServerEvent, discriminator="conversation.item.truncated"):
    """Returned when an earlier assistant audio message item is truncated by the
    client with a ``conversation.item.truncate`` event. This event is used to
    synchronize the server's understanding of the audio with the client's playback.

    This action will truncate the audio and remove the server-side text transcript
    to ensure there is no text in the context that hasn't been heard by the user.

    :ivar type: The event type, must be ``conversation.item.truncated``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.CONVERSATION_ITEM_TRUNCATED
    :ivar item_id: The ID of the assistant message item that was truncated. Required.
    :vartype item_id: str
    :ivar content_index: The index of the content part that was truncated. Required.
    :vartype content_index: int
    :ivar audio_end_ms: The duration up to which the audio was truncated, in milliseconds.
     Required.
    :vartype audio_end_ms: int
    :ivar event_id:
    :vartype event_id: str
    """

    type: Literal[ServerEventType.CONVERSATION_ITEM_TRUNCATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``conversation.item.truncated``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the assistant message item that was truncated. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that was truncated. Required."""
    audio_end_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The duration up to which the audio was truncated, in milliseconds. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        content_index: int,
        audio_end_ms: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.CONVERSATION_ITEM_TRUNCATED, **kwargs)


class ServerEventError(ServerEvent, discriminator="error"):
    """Returned when an error occurs, which could be a client problem or a server
    problem. Most errors are recoverable and the session will stay open, we
    recommend to implementors to monitor and log error messages by default.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``error``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.ERROR
    :ivar error: Details of the error. Required.
    :vartype error: ~azure.ai.voicelive.models.ServerEventErrorDetails
    """

    type: Literal[ServerEventType.ERROR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``error``. Required."""
    error: "_models.ServerEventErrorDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details of the error. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.ServerEventErrorDetails",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.ERROR, **kwargs)


class ServerEventErrorDetails(_Model):
    """ServerEventErrorDetails.

    :ivar type: The type of error (e.g., "invalid_request_error", "server_error"). Required.
    :vartype type: str
    :ivar code: Error code, if any.
    :vartype code: str
    :ivar message: A human-readable error message. Required.
    :vartype message: str
    :ivar param: Parameter related to the error, if any.
    :vartype param: str
    :ivar event_id: The event_id of the client event that caused the error, if applicable.
    :vartype event_id: str
    """

    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of error (e.g., \"invalid_request_error\", \"server_error\"). Required."""
    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code, if any."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable error message. Required."""
    param: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Parameter related to the error, if any."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The event_id of the client event that caused the error, if applicable."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        message: str,
        code: Optional[str] = None,
        param: Optional[str] = None,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ServerEventInputAudioBufferCleared(ServerEvent, discriminator="input_audio_buffer.cleared"):
    """Returned when the input audio buffer is cleared by the client with a
    ``input_audio_buffer.clear`` event.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.cleared``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_CLEARED
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_CLEARED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.cleared``. Required."""

    @overload
    def __init__(
        self,
        *,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.INPUT_AUDIO_BUFFER_CLEARED, **kwargs)


class ServerEventInputAudioBufferCommitted(ServerEvent, discriminator="input_audio_buffer.committed"):
    """Returned when an input audio buffer is committed, either by the client or
    automatically in server VAD mode. The ``item_id`` property is the ID of the user
    message item that will be created, thus a ``conversation.item.created`` event
    will also be sent to the client.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.committed``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_COMMITTED
    :ivar previous_item_id: The ID of the preceding item after which the new item will be inserted.
    :vartype previous_item_id: str
    :ivar item_id: The ID of the user message item that will be created. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_COMMITTED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.committed``. Required."""
    previous_item_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the preceding item after which the new item will be inserted."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item that will be created. Required."""

    @overload
    def __init__(
        self,
        *,
        item_id: str,
        event_id: Optional[str] = None,
        previous_item_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.INPUT_AUDIO_BUFFER_COMMITTED, **kwargs)


class ServerEventInputAudioBufferSpeechStarted(ServerEvent, discriminator="input_audio_buffer.speech_started"):
    """Sent by the server when in ``server_vad`` mode to indicate that speech has been
    detected in the audio buffer. This can happen any time audio is added to the
    buffer (unless speech is already detected). The client may want to use this
    event to interrupt audio playback or provide visual feedback to the user.

    The client should expect to receive a ``input_audio_buffer.speech_stopped`` event
    when speech stops. The ``item_id`` property is the ID of the user message item
    that will be created when speech stops and will also be included in the
    ``input_audio_buffer.speech_stopped`` event (unless the client manually commits
    the audio buffer during VAD activation).

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.speech_started``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_SPEECH_STARTED
    :ivar audio_start_ms: Milliseconds from the start of all audio written to the buffer during the
     session when speech was first detected. This will correspond to the
     beginning of audio sent to the model, and thus includes the
     ``prefix_padding_ms`` configured in the Session. Required.
    :vartype audio_start_ms: int
    :ivar item_id: The ID of the user message item that will be created when speech stops.
     Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STARTED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.speech_started``. Required."""
    audio_start_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Milliseconds from the start of all audio written to the buffer during the
     session when speech was first detected. This will correspond to the
     beginning of audio sent to the model, and thus includes the
     ``prefix_padding_ms`` configured in the Session. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item that will be created when speech stops. Required."""

    @overload
    def __init__(
        self,
        *,
        audio_start_ms: int,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STARTED, **kwargs)


class ServerEventInputAudioBufferSpeechStopped(ServerEvent, discriminator="input_audio_buffer.speech_stopped"):
    """Returned in ``server_vad`` mode when the server detects the end of speech in
    the audio buffer. The server will also send an ``conversation.item.created``
    event with the user message item that is created from the audio buffer.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``input_audio_buffer.speech_stopped``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.INPUT_AUDIO_BUFFER_SPEECH_STOPPED
    :ivar audio_end_ms: Milliseconds since the session started when speech stopped. This will
     correspond to the end of audio sent to the model, and thus includes the
     ``min_silence_duration_ms`` configured in the Session. Required.
    :vartype audio_end_ms: int
    :ivar item_id: The ID of the user message item that will be created. Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STOPPED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``input_audio_buffer.speech_stopped``. Required."""
    audio_end_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Milliseconds since the session started when speech stopped. This will
     correspond to the end of audio sent to the model, and thus includes the
     ``min_silence_duration_ms`` configured in the Session. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the user message item that will be created. Required."""

    @overload
    def __init__(
        self,
        *,
        audio_end_ms: int,
        item_id: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.INPUT_AUDIO_BUFFER_SPEECH_STOPPED, **kwargs)


class ServerEventResponseAnimationBlendshapeDelta(
    ServerEvent, discriminator="response.animation_blendshapes.delta"
):  # pylint: disable=name-too-long
    """Represents a delta update of blendshape animation frames for a specific output of a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_BLENDSHAPES_DELTA
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    :ivar frames: Required. Is either a [[float]] type or a str type.
    :vartype frames: list[list[float]] or str
    :ivar frame_index: Required.
    :vartype frame_index: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    frames: Union[List[List[float]], str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Is either a [[float]] type or a str type."""
    frame_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        frames: Union[List[List[float]], str],
        frame_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DELTA, **kwargs)


class ServerEventResponseAnimationBlendshapeDone(
    ServerEvent, discriminator="response.animation_blendshapes.done"
):  # pylint: disable=name-too-long
    """Indicates the completion of blendshape animation processing for a specific output of a
    response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_BLENDSHAPES_DONE
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_ANIMATION_BLENDSHAPES_DONE, **kwargs)


class ServerEventResponseAnimationVisemeDelta(ServerEvent, discriminator="response.animation_viseme.delta"):
    """Represents a viseme ID delta update for animation based on audio.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_VISEME_DELTA
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    :ivar audio_offset_ms: Required.
    :vartype audio_offset_ms: int
    :ivar viseme_id: Required.
    :vartype viseme_id: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_VISEME_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_offset_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    viseme_id: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        audio_offset_ms: int,
        viseme_id: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_ANIMATION_VISEME_DELTA, **kwargs)


class ServerEventResponseAnimationVisemeDone(ServerEvent, discriminator="response.animation_viseme.done"):
    """Indicates completion of viseme animation delivery for a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_ANIMATION_VISEME_DONE
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    """

    type: Literal[ServerEventType.RESPONSE_ANIMATION_VISEME_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_ANIMATION_VISEME_DONE, **kwargs)


class ServerEventResponseAudioDelta(ServerEvent, discriminator="response.audio.delta"):
    """Returned when the model-generated audio is updated.

    :ivar type: The event type, must be ``response.audio.delta``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar delta: Base64-encoded audio data delta. Required.
    :vartype delta: bytes
    :ivar event_id:
    :vartype event_id: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio.delta``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    delta: bytes = rest_field(visibility=["read", "create", "update", "delete", "query"], format="base64")
    """Base64-encoded audio data delta. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: bytes,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_AUDIO_DELTA, **kwargs)


class ServerEventResponseAudioDone(ServerEvent, discriminator="response.audio.done"):
    """Returned when the model-generated audio is done. Also emitted when a Response
    is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio.done``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_AUDIO_DONE, **kwargs)


class ServerEventResponseAudioTimestampDelta(ServerEvent, discriminator="response.audio_timestamp.delta"):
    """Represents a word-level audio timestamp delta for a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TIMESTAMP_DELTA
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    :ivar audio_offset_ms: Required.
    :vartype audio_offset_ms: int
    :ivar audio_duration_ms: Required.
    :vartype audio_duration_ms: int
    :ivar text: Required.
    :vartype text: str
    :ivar timestamp_type: Required. Default value is "word".
    :vartype timestamp_type: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_offset_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_duration_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    timestamp_type: Literal["word"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"word\"."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        audio_offset_ms: int,
        audio_duration_ms: int,
        text: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DELTA, **kwargs)
        self.timestamp_type: Literal["word"] = "word"


class ServerEventResponseAudioTimestampDone(ServerEvent, discriminator="response.audio_timestamp.done"):
    """Indicates completion of audio timestamp delivery for a response.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TIMESTAMP_DONE
    :ivar response_id: Required.
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    :ivar output_index: Required.
    :vartype output_index: int
    :ivar content_index: Required.
    :vartype content_index: int
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_AUDIO_TIMESTAMP_DONE, **kwargs)


class ServerEventResponseAudioTranscriptDelta(ServerEvent, discriminator="response.audio_transcript.delta"):
    """Returned when the model-generated transcription of audio output is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio_transcript.delta``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TRANSCRIPT_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar delta: The transcript delta. Required.
    :vartype delta: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio_transcript.delta``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The transcript delta. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DELTA, **kwargs)


class ServerEventResponseAudioTranscriptDone(ServerEvent, discriminator="response.audio_transcript.done"):
    """Returned when the model-generated transcription of audio output is done
    streaming. Also emitted when a Response is interrupted, incomplete, or
    cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.audio_transcript.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_AUDIO_TRANSCRIPT_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar transcript: The final transcript of the audio. Required.
    :vartype transcript: str
    """

    type: Literal[ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.audio_transcript.done``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    transcript: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final transcript of the audio. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        transcript: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_AUDIO_TRANSCRIPT_DONE, **kwargs)


class ServerEventResponseContentPartAdded(ServerEvent, discriminator="response.content_part.added"):
    """Returned when a new content part is added to an assistant message item during
    response generation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.content_part.added``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CONTENT_PART_ADDED
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item to which the content part was added. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar part: The content part that was added. Required.
    :vartype part: ~azure.ai.voicelive.models.ContentPart
    """

    type: Literal[ServerEventType.RESPONSE_CONTENT_PART_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.content_part.added``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item to which the content part was added. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    part: "_models.ContentPart" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content part that was added. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        part: "_models.ContentPart",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_CONTENT_PART_ADDED, **kwargs)


class ServerEventResponseContentPartDone(ServerEvent, discriminator="response.content_part.done"):
    """Returned when a content part is done streaming in an assistant message item.
    Also emitted when a Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.content_part.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CONTENT_PART_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar part: The content part that is done. Required.
    :vartype part: ~azure.ai.voicelive.models.ContentPart
    """

    type: Literal[ServerEventType.RESPONSE_CONTENT_PART_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.content_part.done``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    part: "_models.ContentPart" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content part that is done. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        part: "_models.ContentPart",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_CONTENT_PART_DONE, **kwargs)


class ServerEventResponseCreated(ServerEvent, discriminator="response.created"):
    """Returned when a new Response is created. The first event of response creation,
    where the response is in an initial state of ``in_progress``.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.created``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_CREATED
    :ivar response: Required.
    :vartype response: ~azure.ai.voicelive.models.Response
    """

    type: Literal[ServerEventType.RESPONSE_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.created``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response: "_models.Response",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_CREATED, **kwargs)


class ServerEventResponseDone(ServerEvent, discriminator="response.done"):
    """Returned when a Response is done streaming. Always emitted, no matter the
    final state. The Response object included in the ``response.done`` event will
    include all output Items in the Response but will omit the raw audio data.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_DONE
    :ivar response: Required.
    :vartype response: ~azure.ai.voicelive.models.Response
    """

    type: Literal[ServerEventType.RESPONSE_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.done``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        response: "_models.Response",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_DONE, **kwargs)


class ServerEventResponseEmotionHypothesis(ServerEvent, discriminator="response.emotion_hypothesis"):
    """Represents an emotion hypothesis detected from response audio with multiple candidates.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_EMOTION_HYPOTHESIS
    :ivar emotion: Required.
    :vartype emotion: str
    :ivar candidates: Required.
    :vartype candidates: list[~azure.ai.voicelive.models._models.EmotionCandidate]
    :ivar audio_offset_ms: Required.
    :vartype audio_offset_ms: int
    :ivar audio_duration_ms: Required.
    :vartype audio_duration_ms: int
    :ivar response_id:
    :vartype response_id: str
    :ivar item_id: Required.
    :vartype item_id: str
    """

    type: Literal[ServerEventType.RESPONSE_EMOTION_HYPOTHESIS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    emotion: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    candidates: List["_models._models.EmotionCandidate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    audio_offset_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    audio_duration_ms: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    response_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        emotion: str,
        candidates: List["_models._models.EmotionCandidate"],
        audio_offset_ms: int,
        audio_duration_ms: int,
        item_id: str,
        event_id: Optional[str] = None,
        response_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_EMOTION_HYPOTHESIS, **kwargs)


class ServerEventResponseFunctionCallArgumentsDelta(
    ServerEvent, discriminator="response.function_call_arguments.delta"
):  # pylint: disable=name-too-long
    """Returned when the model-generated function call arguments are updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.function_call_arguments.delta``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the function call item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar call_id: The ID of the function call. Required.
    :vartype call_id: str
    :ivar delta: The arguments delta as a JSON string. Required.
    :vartype delta: str
    """

    type: Literal[ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.function_call_arguments.delta``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The arguments delta as a JSON string. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        call_id: str,
        delta: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA, **kwargs)


class ServerEventResponseFunctionCallArgumentsDone(
    ServerEvent, discriminator="response.function_call_arguments.done"
):  # pylint: disable=name-too-long
    """Returned when the model-generated function call arguments are done streaming.
    Also emitted when a Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.function_call_arguments.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the function call item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar call_id: The ID of the function call. Required.
    :vartype call_id: str
    :ivar arguments: The final arguments as a JSON string. Required.
    :vartype arguments: str
    :ivar name: The name of the function call. Required.
    :vartype name: str
    """

    type: Literal[ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.function_call_arguments.done``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the function call. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final arguments as a JSON string. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function call. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        call_id: str,
        arguments: str,
        name: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE, **kwargs)


class ServerEventResponseOutputItemAdded(ServerEvent, discriminator="response.output_item.added"):
    """Returned when a new Item is created during Response generation.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.output_item.added``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_OUTPUT_ITEM_ADDED
    :ivar response_id: The ID of the Response to which the item belongs. Required.
    :vartype response_id: str
    :ivar output_index: The index of the output item in the Response. Required.
    :vartype output_index: int
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    """

    type: Literal[ServerEventType.RESPONSE_OUTPUT_ITEM_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.output_item.added``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Response to which the item belongs. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the Response. Required."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        output_index: int,
        event_id: Optional[str] = None,
        item: Optional["_models.ResponseItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_OUTPUT_ITEM_ADDED, **kwargs)


class ServerEventResponseOutputItemDone(ServerEvent, discriminator="response.output_item.done"):
    """Returned when an Item is done streaming. Also emitted when a Response is
    interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.output_item.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_OUTPUT_ITEM_DONE
    :ivar response_id: The ID of the Response to which the item belongs. Required.
    :vartype response_id: str
    :ivar output_index: The index of the output item in the Response. Required.
    :vartype output_index: int
    :ivar item:
    :vartype item: ~azure.ai.voicelive.models.ResponseItem
    """

    type: Literal[ServerEventType.RESPONSE_OUTPUT_ITEM_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.output_item.done``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the Response to which the item belongs. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the Response. Required."""
    item: Optional["_models.ResponseItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        output_index: int,
        event_id: Optional[str] = None,
        item: Optional["_models.ResponseItem"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_OUTPUT_ITEM_DONE, **kwargs)


class ServerEventResponseTextDelta(ServerEvent, discriminator="response.text.delta"):
    """Returned when the text value of a "text" content part is updated.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.text.delta``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_TEXT_DELTA
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar delta: The text delta. Required.
    :vartype delta: str
    """

    type: Literal[ServerEventType.RESPONSE_TEXT_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.text.delta``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text delta. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_TEXT_DELTA, **kwargs)


class ServerEventResponseTextDone(ServerEvent, discriminator="response.text.done"):
    """Returned when the text value of a "text" content part is done streaming. Also
    emitted when a Response is interrupted, incomplete, or cancelled.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``response.text.done``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.RESPONSE_TEXT_DONE
    :ivar response_id: The ID of the response. Required.
    :vartype response_id: str
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part in the item's content array. Required.
    :vartype content_index: int
    :ivar text: The final text content. Required.
    :vartype text: str
    """

    type: Literal[ServerEventType.RESPONSE_TEXT_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``response.text.done``. Required."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the response. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part in the item's content array. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final text content. Required."""

    @overload
    def __init__(
        self,
        *,
        response_id: str,
        item_id: str,
        output_index: int,
        content_index: int,
        text: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.RESPONSE_TEXT_DONE, **kwargs)


class ServerEventSessionAvatarConnecting(ServerEvent, discriminator="session.avatar.connecting"):
    """Sent when the server is in the process of establishing an avatar media connection and provides
    its SDP answer.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be 'session.avatar.connecting'. Required.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_AVATAR_CONNECTING
    :ivar server_sdp: The server's SDP answer for the avatar connection. Required.
    :vartype server_sdp: str
    """

    type: Literal[ServerEventType.SESSION_AVATAR_CONNECTING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be 'session.avatar.connecting'. Required."""
    server_sdp: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The server's SDP answer for the avatar connection. Required."""

    @overload
    def __init__(
        self,
        *,
        server_sdp: str,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.SESSION_AVATAR_CONNECTING, **kwargs)


class ServerEventSessionCreated(ServerEvent, discriminator="session.created"):
    """Returned when a Session is created. Emitted automatically when a new
    connection is established as the first server event. This event will contain
    the default Session configuration.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``session.created``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_CREATED
    :ivar session: Required.
    :vartype session: ~azure.ai.voicelive.models.ResponseSession
    """

    type: Literal[ServerEventType.SESSION_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``session.created``. Required."""
    session: "_models.ResponseSession" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        session: "_models.ResponseSession",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.SESSION_CREATED, **kwargs)


class ServerEventSessionUpdated(ServerEvent, discriminator="session.updated"):
    """Returned when a session is updated with a ``session.update`` event, unless
    there is an error.

    :ivar event_id:
    :vartype event_id: str
    :ivar type: The event type, must be ``session.updated``. Required.
    :vartype type: str or ~azure.ai.voicelive.models.SESSION_UPDATED
    :ivar session: Required.
    :vartype session: ~azure.ai.voicelive.models.ResponseSession
    """

    type: Literal[ServerEventType.SESSION_UPDATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The event type, must be ``session.updated``. Required."""
    session: "_models.ResponseSession" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        session: "_models.ResponseSession",
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ServerEventType.SESSION_UPDATED, **kwargs)


class ServerVad(TurnDetection, discriminator="server_vad"):
    """Base model for VAD-based turn detection.

    :ivar type: Required. Default value is "server_vad".
    :vartype type: str
    :ivar threshold:
    :vartype threshold: float
    :ivar prefix_padding_ms:
    :vartype prefix_padding_ms: int
    :ivar silence_duration_ms:
    :vartype silence_duration_ms: int
    :ivar end_of_utterance_detection:
    :vartype end_of_utterance_detection: ~azure.ai.voicelive.models.EOUDetection
    :ivar auto_truncate:
    :vartype auto_truncate: bool
    """

    type: Literal["server_vad"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"server_vad\"."""
    threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    prefix_padding_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    silence_duration_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    end_of_utterance_detection: Optional["_models.EOUDetection"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    auto_truncate: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        threshold: Optional[float] = None,
        prefix_padding_ms: Optional[int] = None,
        silence_duration_ms: Optional[int] = None,
        end_of_utterance_detection: Optional["_models.EOUDetection"] = None,
        auto_truncate: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type="server_vad", **kwargs)


class SystemMessageItem(MessageItem, discriminator="system"):
    """SystemMessageItem.

    :ivar id:
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    :ivar role: Required. Default value is "system".
    :vartype role: str
    :ivar content: Required.
    :vartype content: list[~azure.ai.voicelive.models.InputTextContentPart]
    """

    __mapping__: Dict[str, _Model] = {}
    role: Literal["system"] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"system\"."""
    content: List["_models.InputTextContentPart"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        content: List["_models.InputTextContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, role="system", **kwargs)


class ToolChoiceObject(_Model):
    """A base representation for a voicelive tool_choice selecting a named tool.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ToolChoiceFunctionObject

    :ivar type: Required. "function"
    :vartype type: str or ~azure.ai.voicelive.models.ToolType
    """

    __mapping__: Dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. \"function\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolChoiceFunctionObject(ToolChoiceObject, discriminator="function"):
    """The representation of a voicelive tool_choice selecting a named function tool.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.FUNCTION
    :ivar function: Required.
    :vartype function: ~azure.ai.voicelive.models.ToolChoiceFunctionObjectFunction
    """

    type: Literal[ToolType.FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    function: "_models.ToolChoiceFunctionObjectFunction" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        function: "_models.ToolChoiceFunctionObjectFunction",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, type=ToolType.FUNCTION, **kwargs)


class ToolChoiceFunctionObjectFunction(_Model):
    """ToolChoiceFunctionObjectFunction.

    :ivar name: Required.
    :vartype name: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Usage(_Model):
    """Overall usage statistics for a response.

    :ivar total_tokens: Total number of tokens (input + output). Required.
    :vartype total_tokens: int
    :ivar input_tokens: Number of input tokens. Required.
    :vartype input_tokens: int
    :ivar output_tokens: Number of output tokens. Required.
    :vartype output_tokens: int
    :ivar input_token_details: Detailed breakdown of input tokens. Required.
    :vartype input_token_details: ~azure.ai.voicelive.models.InputTokenDetails
    :ivar output_token_details: Detailed breakdown of output tokens. Required.
    :vartype output_token_details: ~azure.ai.voicelive.models.OutputTokenDetails
    """

    total_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Total number of tokens (input + output). Required."""
    input_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of input tokens. Required."""
    output_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of output tokens. Required."""
    input_token_details: "_models.InputTokenDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Detailed breakdown of input tokens. Required."""
    output_token_details: "_models.OutputTokenDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Detailed breakdown of output tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        total_tokens: int,
        input_tokens: int,
        output_tokens: int,
        input_token_details: "_models.InputTokenDetails",
        output_token_details: "_models.OutputTokenDetails",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserMessageItem(MessageItem, discriminator="user"):
    """UserMessageItem.

    :ivar id:
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.voicelive.models.MESSAGE
    :ivar status: Known values are: "completed" and "incomplete".
    :vartype status: str or ~azure.ai.voicelive.models.ItemParamStatus
    :ivar role: Required. Default value is "user".
    :vartype role: str
    :ivar content: Required.
    :vartype content: list[~azure.ai.voicelive.models.UserContentPart]
    """

    __mapping__: Dict[str, _Model] = {}
    role: Literal["user"] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"user\"."""
    content: List["_models.UserContentPart"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        content: List["_models.UserContentPart"],
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        status: Optional[Union[str, "_models.ItemParamStatus"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, role="user", **kwargs)


class VideoCrop(_Model):
    """Defines a video crop rectangle using top-left and bottom-right coordinates.

    :ivar top_left: Top-left corner of the crop region. Array of [x, y], must be non-negative
     integers. Required.
    :vartype top_left: list[int]
    :ivar bottom_right: Bottom-right corner of the crop region. Array of [x, y], must be
     non-negative integers. Required.
    :vartype bottom_right: list[int]
    """

    top_left: List[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Top-left corner of the crop region. Array of [x, y], must be non-negative integers. Required."""
    bottom_right: List[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bottom-right corner of the crop region. Array of [x, y], must be non-negative integers.
     Required."""

    @overload
    def __init__(
        self,
        *,
        top_left: List[int],
        bottom_right: List[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VideoParams(_Model):
    """Video streaming parameters for avatar.

    :ivar bitrate: Bitrate in bits per second (e.g., 2000000 for 2 Mbps).
    :vartype bitrate: int
    :ivar codec: Codec to use for encoding. Currently only 'h264' is supported. Default value is
     "h264".
    :vartype codec: str
    :ivar crop: Optional cropping settings for the video stream.
    :vartype crop: ~azure.ai.voicelive.models.VideoCrop
    :ivar resolution: Optional resolution settings for the video stream.
    :vartype resolution: ~azure.ai.voicelive.models.VideoResolution
    """

    bitrate: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Bitrate in bits per second (e.g., 2000000 for 2 Mbps)."""
    codec: Optional[Literal["h264"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Codec to use for encoding. Currently only 'h264' is supported. Default value is \"h264\"."""
    crop: Optional["_models.VideoCrop"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional cropping settings for the video stream."""
    resolution: Optional["_models.VideoResolution"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional resolution settings for the video stream."""

    @overload
    def __init__(
        self,
        *,
        bitrate: Optional[int] = None,
        codec: Optional[Literal["h264"]] = None,
        crop: Optional["_models.VideoCrop"] = None,
        resolution: Optional["_models.VideoResolution"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VideoResolution(_Model):
    """Resolution of the video feed in pixels.

    :ivar width: Width of the video in pixels. Must be greater than 0. Required.
    :vartype width: int
    :ivar height: Height of the video in pixels. Must be greater than 0. Required.
    :vartype height: int
    """

    width: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Width of the video in pixels. Must be greater than 0. Required."""
    height: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Height of the video in pixels. Must be greater than 0. Required."""

    @overload
    def __init__(
        self,
        *,
        width: int,
        height: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VoiceLiveErrorDetails(_Model):
    """Error object returned in case of API failure.

    :ivar code: Error code, or null if unspecified.
    :vartype code: str
    :ivar message: Human-readable error message. Required.
    :vartype message: str
    :ivar param: Parameter name related to the error, if applicable.
    :vartype param: str
    :ivar type: Type or category of the error.
    :vartype type: str
    :ivar event_id: Event id of the error.
    :vartype event_id: str
    """

    code: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error code, or null if unspecified."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Human-readable error message. Required."""
    param: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Parameter name related to the error, if applicable."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type or category of the error."""
    event_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Event id of the error."""

    @overload
    def __init__(
        self,
        *,
        message: str,
        code: Optional[str] = None,
        param: Optional[str] = None,
        type: Optional[str] = None,
        event_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
