"""Models for supervisor client."""

from aiohasupervisor.models.addons import (
    AddonBoot,
    AddonBootConfig,
    AddonsConfigValidate,
    AddonsOptions,
    AddonsRebuild,
    AddonsSecurityOptions,
    AddonsStats,
    AddonStage,
    AddonStartup,
    AddonState,
    AddonsUninstall,
    AppArmor,
    Capability,
    CpuArch,
    InstalledAddon,
    InstalledAddonComplete,
    Repository,
    StoreAddon,
    StoreAddonComplete,
    StoreAddonUpdate,
    StoreAddRepository,
    StoreInfo,
    SupervisorRole,
)
from aiohasupervisor.models.backups import (
    LOCATION_CLOUD_BACKUP,
    LOCATION_LOCAL_STORAGE,
    AddonSet,
    Backup,
    BackupAddon,
    BackupComplete,
    BackupContent,
    BackupJob,
    BackupLocationAttributes,
    BackupsInfo,
    BackupsOptions,
    BackupType,
    DownloadBackupOptions,
    Folder,
    FreezeOptions,
    FullBackupOptions,
    FullRestoreOptions,
    NewBackup,
    PartialBackupOptions,
    PartialRestoreOptions,
    RemoveBackupOptions,
    UploadBackupOptions,
)
from aiohasupervisor.models.discovery import (
    Discovery,
    DiscoveryConfig,
)
from aiohasupervisor.models.homeassistant import (
    HomeAssistantInfo,
    HomeAssistantOptions,
    HomeAssistantRebuildOptions,
    HomeAssistantRestartOptions,
    HomeAssistantStats,
    HomeAssistantStopOptions,
    HomeAssistantUpdateOptions,
)
from aiohasupervisor.models.host import (
    HostInfo,
    HostOptions,
    RebootOptions,
    Service,
    ServiceState,
    ShutdownOptions,
)
from aiohasupervisor.models.jobs import (
    Job,
    JobCondition,
    JobError,
    JobsInfo,
    JobsOptions,
)
from aiohasupervisor.models.mounts import (
    CIFSMountRequest,
    CIFSMountResponse,
    MountCifsVersion,
    MountsInfo,
    MountsOptions,
    MountState,
    MountType,
    MountUsage,
    NFSMountRequest,
    NFSMountResponse,
)
from aiohasupervisor.models.network import (
    AccessPoint,
    AuthMethod,
    DockerNetwork,
    InterfaceMethod,
    InterfaceType,
    IPv4,
    IPv4Config,
    IPv6,
    IPv6Config,
    NetworkInfo,
    NetworkInterface,
    NetworkInterfaceConfig,
    Vlan,
    VlanConfig,
    Wifi,
    WifiConfig,
    WifiMode,
)
from aiohasupervisor.models.os import (
    BootSlot,
    BootSlotName,
    DataDisk,
    GreenInfo,
    GreenOptions,
    MigrateDataOptions,
    OSInfo,
    OSUpdate,
    RaucState,
    SetBootSlotOptions,
    YellowInfo,
    YellowOptions,
)
from aiohasupervisor.models.resolution import (
    Check,
    CheckOptions,
    CheckType,
    ContextType,
    Issue,
    IssueType,
    ResolutionInfo,
    Suggestion,
    SuggestionType,
    UnhealthyReason,
    UnsupportedReason,
)
from aiohasupervisor.models.root import (
    AvailableUpdate,
    HostFeature,
    LogLevel,
    RootInfo,
    SupervisorState,
    UpdateChannel,
    UpdateType,
)
from aiohasupervisor.models.supervisor import (
    DetectBlockingIO,
    SupervisorInfo,
    SupervisorOptions,
    SupervisorStats,
    SupervisorUpdateOptions,
)

__all__ = [
    "LOCATION_CLOUD_BACKUP",
    "LOCATION_LOCAL_STORAGE",
    "AccessPoint",
    "AddonBoot",
    "AddonBootConfig",
    "AddonSet",
    "AddonStage",
    "AddonStartup",
    "AddonState",
    "AddonsConfigValidate",
    "AddonsOptions",
    "AddonsRebuild",
    "AddonsSecurityOptions",
    "AddonsStats",
    "AddonsUninstall",
    "AppArmor",
    "AuthMethod",
    "AvailableUpdate",
    "Backup",
    "BackupAddon",
    "BackupComplete",
    "BackupContent",
    "BackupJob",
    "BackupLocationAttributes",
    "BackupType",
    "BackupsInfo",
    "BackupsOptions",
    "BootSlot",
    "BootSlotName",
    "CIFSMountRequest",
    "CIFSMountResponse",
    "Capability",
    "Check",
    "CheckOptions",
    "CheckType",
    "ContextType",
    "CpuArch",
    "DataDisk",
    "DetectBlockingIO",
    "Discovery",
    "DiscoveryConfig",
    "DockerNetwork",
    "DownloadBackupOptions",
    "Folder",
    "FreezeOptions",
    "FullBackupOptions",
    "FullRestoreOptions",
    "GreenInfo",
    "GreenOptions",
    "HomeAssistantInfo",
    "HomeAssistantOptions",
    "HomeAssistantRebuildOptions",
    "HomeAssistantRestartOptions",
    "HomeAssistantStats",
    "HomeAssistantStopOptions",
    "HomeAssistantUpdateOptions",
    "HostFeature",
    "HostInfo",
    "HostOptions",
    "IPv4",
    "IPv4Config",
    "IPv6",
    "IPv6Config",
    "InstalledAddon",
    "InstalledAddonComplete",
    "InterfaceMethod",
    "InterfaceType",
    "Issue",
    "IssueType",
    "Job",
    "JobCondition",
    "JobError",
    "JobsInfo",
    "JobsOptions",
    "LogLevel",
    "MigrateDataOptions",
    "MountCifsVersion",
    "MountState",
    "MountType",
    "MountUsage",
    "MountsInfo",
    "MountsOptions",
    "NFSMountRequest",
    "NFSMountResponse",
    "NetworkInfo",
    "NetworkInterface",
    "NetworkInterfaceConfig",
    "NewBackup",
    "OSInfo",
    "OSUpdate",
    "PartialBackupOptions",
    "PartialRestoreOptions",
    "RaucState",
    "RebootOptions",
    "RemoveBackupOptions",
    "Repository",
    "ResolutionInfo",
    "RootInfo",
    "Service",
    "ServiceState",
    "SetBootSlotOptions",
    "ShutdownOptions",
    "StoreAddRepository",
    "StoreAddon",
    "StoreAddonComplete",
    "StoreAddonUpdate",
    "StoreInfo",
    "Suggestion",
    "SuggestionType",
    "SupervisorInfo",
    "SupervisorOptions",
    "SupervisorRole",
    "SupervisorState",
    "SupervisorStats",
    "SupervisorUpdateOptions",
    "UnhealthyReason",
    "UnsupportedReason",
    "UpdateChannel",
    "UpdateType",
    "UploadBackupOptions",
    "Vlan",
    "VlanConfig",
    "Wifi",
    "WifiConfig",
    "WifiMode",
    "YellowInfo",
    "YellowOptions",
]
