---
version: 2.11.5.0
date: 2025-08-26
channel: "release"
---

## New Features

- <!-- JAL-4436 --> Colour alignments and subgroups by secondary structure conservation
- <!-- JAL-4513 --> Consistent assignment of colours to groups when a tree is cut rather than picking them randomly
- <!-- JAL-3880,JAL-4411, JAL-4441,JAL-4548 --> Display of chain IDs and provider for annotation tracks derived from 3D structure data  
- <!-- JAL-4555 --> Sort alignment or selection by sequence description
- <!-- JAL-4469 --> Uniprot Sequence Fetcher dialog allows version numbers to be excluded when given a list of IDs

### Secondary structure based trees
- <!-- JAL-4399, JAL-4517,JAL-4518, JAL-4542, JAL-4386, JAL-4528 --> Create secondary structure annotation trees linked to all chains and structure datasources for one or more sequences
- <!-- JAL-4509, JAL-4435, JAL-4515 --> Option to show structure providers as coloured lines mapped onto secondary structure annotation trees 
- <!-- JAL-4515 --> Annotation tree's groups are shown as coloured rectangles rather then coloured branch lines
- <!-- JAL-4334 --> Structure import via command line allows multiple structure import and superimposition
- <!-- JAL-4542 --> Annotations associated with selected sequences are also highlighted in annotation panel
- <!-- JAL-4527 --> Extended Jalview's Alignment Annotation File format to allow key-value pairs and CALC_ID metdata fields to be exported and imported
- <!-- JAL-4570 --> PAE tree is now always shown above the alignment view

### Structure and Annotation(s)
- <!-- JAL-3914 --> Model reliability annotations for structures retrieved from 3D-Beacons are labelled with their reported score type (e.g. QMeansDiSCO_)
- <!-- JAL-4392,JAL-3987 --> Consensus secondary structure annotation rows for sequences with multiple sources of structural data 

### Installer
- <!-- JAL-4530 --> Easier OSX installs for people working on enterprise-managed macs via a new 'Install Jalview.app' helper tool in the OSX Installation DMG 

### Command-line 
- <!-- JAL-4354 --> Allow many structure(s) to be loaded and viewed (optionally superimposed) via command line
- <!-- JAL-811, JAL-4426 --> Report number of annotation tracks and sequences involved in consensus, conservation, quality, occupancy and secondary structure consensus

### Anayltics
- <!-- JAL-4541 --> More robust mechanism for logging usage statistics with jalview.org

### Development
- <!-- JAL-4428 --> Improved integration of OSX codesigning process when releasing Jalview

## Issues Resolved

- <!-- JAL-3726 --> Sequence ID colourscheme is not applied when view restored from project
- <!-- JAL-4566 --> Jalview can fail to properly import and map a structure to a sequence via the Needleman and Wunsch aligner
- <!-- JAL-4511 --> Jalview 2.11.4.1 doesn't include full platform details in console output
- <!-- JAL-4504,JAL-4500 --> FlatLaF updated from 3.0 to 3.5.4 to fix direct3d related windows 11 redraw problems
- <!-- JAL-4503,JAL-629 --> Location of structure viewer not faithfully saved and restored in project
- <!-- JAL-3921,JAL-4077 --> Jmol views cannot be saved in jalview projects on Windows
- <!-- JAL-4485,JAL-4487,JAL-4350 --> Latest version of ChimeraX not located on Windows
- <!-- JAL-4333 --> Error while using  Calculate -> Translate as cDNA
- <!-- JAL-4557 --> New views for a CDS/Protein alignment have an extra 'cDNA PID' annotation row
- <!-- JAL-4537 --> Tree node labels are grey when a tree is first created then black when redrawn
- <!-- JAL-4568 --> Jalview freezes when trying to export PNG or EPS from Jmol via the File->Export menu
- <!-- JAL-4507 --> Exported Consensus Annotation when loaded via Load Features/Annotations is interpreted as a Pfam format and appears as sequence onto the alignment
- <!-- JAL-4589 --> Empty row in annotation panel shown when alignment first imported
- <!-- JAL-4591 --> Web URLs that do not provide content or encoding headers are not readable

### Command-line

- <!-- JAL-4563 --> Cannot import structure via URL on commandline 
- <!-- JAL-4562 --> CLI ignores additional annotation files specified via --annotations 
- <!-- JAL-4564 --> Can't specify URLs via --open= 
- <!-- JAL-4474 --> jalview command doesn't work on Windows when user has a Network homedir

### Installer

- <!-- JAL-4477 --> Jalview 2.11.4 installer doesn't work for usernames that include non-latin characters 
- <!-- JAL-4491 --> Getdown sets "com.sun.security.enableAIAcaIssuers", "true" to ensure intermediate certificates are downloaded if needed
- <!-- JAL-4505 --> Windows installer unusable when Dark Mode is enabled


### Development

- <!-- JAL-4482 --> linkCheck task fails for jalview test builds when there are links to whatsNew#experimental in documentation 
- <!-- JAL-4397 --> IdWidth display tests failing OSX when scaling=1.0 on a HiDPI display (e.g. 4k monitor)

### Known Defects resolved

- <!-- JAL-4464 --> Cannot store/restore group associated secondary structure consensus annotations
- <!-- JAL-3726 --> Sequence ID colourscheme is not applied when view restored from project
- <!-- JAL-2275 --> Cannot view structures imported from a network mount on Windows
 

### New Known Defects

- <!-- JAL-4521 --> Need to select a single sequence before a tree can be calculated for just it's secondary structure structure annotations 
- <!-- JAL-2690 --> Can't view structures imported by drag and drop of structure URL  
- <!-- JAL-4486 --> Secondary structure annotation not mapped correctly to sequence for some structures
- <!-- JAL-4539 --> When jalview is working with large alignments and little memory, Find can fail with a 'Stack Overflow' exception
- <!-- JAL-4549 --> Trackpad scrolling on annotation panel when structure view is open causes massive slow down
- <!-- JAL-4440 --> Jmol can fail to map positions for models from some 3D-beacons sources (ongoing issue - partially resolved in 2.11.5.0)
- <!-- JAL-4516 --> Resizing an alignment window from the top can completely obscure sequences and annotation divider
- <!-- JAL-4514 --> Residue highlighting in pymol not working in 3.0.4
