package redisenterprise

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PrivateLinkResourcesClient is the REST API for managing Redis Enterprise resources in Azure.
type PrivateLinkResourcesClient struct {
	BaseClient
}

// NewPrivateLinkResourcesClient creates an instance of the PrivateLinkResourcesClient client.
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return NewPrivateLinkResourcesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPrivateLinkResourcesClientWithBaseURI creates an instance of the PrivateLinkResourcesClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return PrivateLinkResourcesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListByRedisEnterpriseCache gets the private link resources that need to be created for a RedisEnterprise cluster.
// Parameters:
// resourceGroupName - the name of the resource group.
// clusterName - the name of the RedisEnterprise cluster.
func (client PrivateLinkResourcesClient) ListByRedisEnterpriseCache(ctx context.Context, resourceGroupName string, clusterName string) (result PrivateLinkResourceListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateLinkResourcesClient.ListByRedisEnterpriseCache")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListByRedisEnterpriseCachePreparer(ctx, resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.PrivateLinkResourcesClient", "ListByRedisEnterpriseCache", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByRedisEnterpriseCacheSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "redisenterprise.PrivateLinkResourcesClient", "ListByRedisEnterpriseCache", resp, "Failure sending request")
		return
	}

	result, err = client.ListByRedisEnterpriseCacheResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "redisenterprise.PrivateLinkResourcesClient", "ListByRedisEnterpriseCache", resp, "Failure responding to request")
		return
	}

	return
}

// ListByRedisEnterpriseCachePreparer prepares the ListByRedisEnterpriseCache request.
func (client PrivateLinkResourcesClient) ListByRedisEnterpriseCachePreparer(ctx context.Context, resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cache/redisEnterprise/{clusterName}/privateLinkResources", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByRedisEnterpriseCacheSender sends the ListByRedisEnterpriseCache request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateLinkResourcesClient) ListByRedisEnterpriseCacheSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByRedisEnterpriseCacheResponder handles the response to the ListByRedisEnterpriseCache request. The method always
// closes the http.Response Body.
func (client PrivateLinkResourcesClient) ListByRedisEnterpriseCacheResponder(resp *http.Response) (result PrivateLinkResourceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
