package insights

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ApplicationType enumerates the values for application type.
type ApplicationType string

const (
	// ApplicationTypeOther ...
	ApplicationTypeOther ApplicationType = "other"
	// ApplicationTypeWeb ...
	ApplicationTypeWeb ApplicationType = "web"
)

// PossibleApplicationTypeValues returns an array of possible values for the ApplicationType const type.
func PossibleApplicationTypeValues() []ApplicationType {
	return []ApplicationType{ApplicationTypeOther, ApplicationTypeWeb}
}

// CategoryType enumerates the values for category type.
type CategoryType string

const (
	// CategoryTypePerformance ...
	CategoryTypePerformance CategoryType = "performance"
	// CategoryTypeRetention ...
	CategoryTypeRetention CategoryType = "retention"
	// CategoryTypeTSG ...
	CategoryTypeTSG CategoryType = "TSG"
	// CategoryTypeWorkbook ...
	CategoryTypeWorkbook CategoryType = "workbook"
)

// PossibleCategoryTypeValues returns an array of possible values for the CategoryType const type.
func PossibleCategoryTypeValues() []CategoryType {
	return []CategoryType{CategoryTypePerformance, CategoryTypeRetention, CategoryTypeTSG, CategoryTypeWorkbook}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// FavoriteSourceType enumerates the values for favorite source type.
type FavoriteSourceType string

const (
	// FavoriteSourceTypeEvents ...
	FavoriteSourceTypeEvents FavoriteSourceType = "events"
	// FavoriteSourceTypeFunnel ...
	FavoriteSourceTypeFunnel FavoriteSourceType = "funnel"
	// FavoriteSourceTypeImpact ...
	FavoriteSourceTypeImpact FavoriteSourceType = "impact"
	// FavoriteSourceTypeNotebook ...
	FavoriteSourceTypeNotebook FavoriteSourceType = "notebook"
	// FavoriteSourceTypeRetention ...
	FavoriteSourceTypeRetention FavoriteSourceType = "retention"
	// FavoriteSourceTypeSegmentation ...
	FavoriteSourceTypeSegmentation FavoriteSourceType = "segmentation"
	// FavoriteSourceTypeSessions ...
	FavoriteSourceTypeSessions FavoriteSourceType = "sessions"
	// FavoriteSourceTypeUserflows ...
	FavoriteSourceTypeUserflows FavoriteSourceType = "userflows"
)

// PossibleFavoriteSourceTypeValues returns an array of possible values for the FavoriteSourceType const type.
func PossibleFavoriteSourceTypeValues() []FavoriteSourceType {
	return []FavoriteSourceType{FavoriteSourceTypeEvents, FavoriteSourceTypeFunnel, FavoriteSourceTypeImpact, FavoriteSourceTypeNotebook, FavoriteSourceTypeRetention, FavoriteSourceTypeSegmentation, FavoriteSourceTypeSessions, FavoriteSourceTypeUserflows}
}

// FavoriteType enumerates the values for favorite type.
type FavoriteType string

const (
	// FavoriteTypeShared ...
	FavoriteTypeShared FavoriteType = "shared"
	// FavoriteTypeUser ...
	FavoriteTypeUser FavoriteType = "user"
)

// PossibleFavoriteTypeValues returns an array of possible values for the FavoriteType const type.
func PossibleFavoriteTypeValues() []FavoriteType {
	return []FavoriteType{FavoriteTypeShared, FavoriteTypeUser}
}

// FlowType enumerates the values for flow type.
type FlowType string

const (
	// FlowTypeBluefield ...
	FlowTypeBluefield FlowType = "Bluefield"
)

// PossibleFlowTypeValues returns an array of possible values for the FlowType const type.
func PossibleFlowTypeValues() []FlowType {
	return []FlowType{FlowTypeBluefield}
}

// IngestionMode enumerates the values for ingestion mode.
type IngestionMode string

const (
	// IngestionModeApplicationInsights ...
	IngestionModeApplicationInsights IngestionMode = "ApplicationInsights"
	// IngestionModeApplicationInsightsWithDiagnosticSettings ...
	IngestionModeApplicationInsightsWithDiagnosticSettings IngestionMode = "ApplicationInsightsWithDiagnosticSettings"
	// IngestionModeLogAnalytics ...
	IngestionModeLogAnalytics IngestionMode = "LogAnalytics"
)

// PossibleIngestionModeValues returns an array of possible values for the IngestionMode const type.
func PossibleIngestionModeValues() []IngestionMode {
	return []IngestionMode{IngestionModeApplicationInsights, IngestionModeApplicationInsightsWithDiagnosticSettings, IngestionModeLogAnalytics}
}

// ItemScope enumerates the values for item scope.
type ItemScope string

const (
	// ItemScopeShared ...
	ItemScopeShared ItemScope = "shared"
	// ItemScopeUser ...
	ItemScopeUser ItemScope = "user"
)

// PossibleItemScopeValues returns an array of possible values for the ItemScope const type.
func PossibleItemScopeValues() []ItemScope {
	return []ItemScope{ItemScopeShared, ItemScopeUser}
}

// ItemScopePath enumerates the values for item scope path.
type ItemScopePath string

const (
	// ItemScopePathAnalyticsItems ...
	ItemScopePathAnalyticsItems ItemScopePath = "analyticsItems"
	// ItemScopePathMyanalyticsItems ...
	ItemScopePathMyanalyticsItems ItemScopePath = "myanalyticsItems"
)

// PossibleItemScopePathValues returns an array of possible values for the ItemScopePath const type.
func PossibleItemScopePathValues() []ItemScopePath {
	return []ItemScopePath{ItemScopePathAnalyticsItems, ItemScopePathMyanalyticsItems}
}

// ItemType enumerates the values for item type.
type ItemType string

const (
	// ItemTypeFolder ...
	ItemTypeFolder ItemType = "folder"
	// ItemTypeFunction ...
	ItemTypeFunction ItemType = "function"
	// ItemTypeQuery ...
	ItemTypeQuery ItemType = "query"
	// ItemTypeRecent ...
	ItemTypeRecent ItemType = "recent"
)

// PossibleItemTypeValues returns an array of possible values for the ItemType const type.
func PossibleItemTypeValues() []ItemType {
	return []ItemType{ItemTypeFolder, ItemTypeFunction, ItemTypeQuery, ItemTypeRecent}
}

// ItemTypeParameter enumerates the values for item type parameter.
type ItemTypeParameter string

const (
	// ItemTypeParameterFolder ...
	ItemTypeParameterFolder ItemTypeParameter = "folder"
	// ItemTypeParameterFunction ...
	ItemTypeParameterFunction ItemTypeParameter = "function"
	// ItemTypeParameterNone ...
	ItemTypeParameterNone ItemTypeParameter = "none"
	// ItemTypeParameterQuery ...
	ItemTypeParameterQuery ItemTypeParameter = "query"
	// ItemTypeParameterRecent ...
	ItemTypeParameterRecent ItemTypeParameter = "recent"
)

// PossibleItemTypeParameterValues returns an array of possible values for the ItemTypeParameter const type.
func PossibleItemTypeParameterValues() []ItemTypeParameter {
	return []ItemTypeParameter{ItemTypeParameterFolder, ItemTypeParameterFunction, ItemTypeParameterNone, ItemTypeParameterQuery, ItemTypeParameterRecent}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// KindShared ...
	KindShared Kind = "shared"
	// KindUser ...
	KindUser Kind = "user"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{KindShared, KindUser}
}

// ManagedServiceIdentityType enumerates the values for managed service identity type.
type ManagedServiceIdentityType string

const (
	// ManagedServiceIdentityTypeNone ...
	ManagedServiceIdentityTypeNone ManagedServiceIdentityType = "None"
	// ManagedServiceIdentityTypeSystemAssigned ...
	ManagedServiceIdentityTypeSystemAssigned ManagedServiceIdentityType = "SystemAssigned"
	// ManagedServiceIdentityTypeSystemAssignedUserAssigned ...
	ManagedServiceIdentityTypeSystemAssignedUserAssigned ManagedServiceIdentityType = "SystemAssigned,UserAssigned"
	// ManagedServiceIdentityTypeUserAssigned ...
	ManagedServiceIdentityTypeUserAssigned ManagedServiceIdentityType = "UserAssigned"
)

// PossibleManagedServiceIdentityTypeValues returns an array of possible values for the ManagedServiceIdentityType const type.
func PossibleManagedServiceIdentityTypeValues() []ManagedServiceIdentityType {
	return []ManagedServiceIdentityType{ManagedServiceIdentityTypeNone, ManagedServiceIdentityTypeSystemAssigned, ManagedServiceIdentityTypeSystemAssignedUserAssigned, ManagedServiceIdentityTypeUserAssigned}
}

// PublicNetworkAccessType enumerates the values for public network access type.
type PublicNetworkAccessType string

const (
	// PublicNetworkAccessTypeDisabled Disables public connectivity to Application Insights through public DNS.
	PublicNetworkAccessTypeDisabled PublicNetworkAccessType = "Disabled"
	// PublicNetworkAccessTypeEnabled Enables connectivity to Application Insights through public DNS.
	PublicNetworkAccessTypeEnabled PublicNetworkAccessType = "Enabled"
)

// PossiblePublicNetworkAccessTypeValues returns an array of possible values for the PublicNetworkAccessType const type.
func PossiblePublicNetworkAccessTypeValues() []PublicNetworkAccessType {
	return []PublicNetworkAccessType{PublicNetworkAccessTypeDisabled, PublicNetworkAccessTypeEnabled}
}

// PurgeState enumerates the values for purge state.
type PurgeState string

const (
	// PurgeStateCompleted ...
	PurgeStateCompleted PurgeState = "completed"
	// PurgeStatePending ...
	PurgeStatePending PurgeState = "pending"
)

// PossiblePurgeStateValues returns an array of possible values for the PurgeState const type.
func PossiblePurgeStateValues() []PurgeState {
	return []PurgeState{PurgeStateCompleted, PurgeStatePending}
}

// RequestSource enumerates the values for request source.
type RequestSource string

const (
	// RequestSourceRest ...
	RequestSourceRest RequestSource = "rest"
)

// PossibleRequestSourceValues returns an array of possible values for the RequestSource const type.
func PossibleRequestSourceValues() []RequestSource {
	return []RequestSource{RequestSourceRest}
}

// SharedTypeKind enumerates the values for shared type kind.
type SharedTypeKind string

const (
	// SharedTypeKindShared ...
	SharedTypeKindShared SharedTypeKind = "shared"
	// SharedTypeKindUser ...
	SharedTypeKindUser SharedTypeKind = "user"
)

// PossibleSharedTypeKindValues returns an array of possible values for the SharedTypeKind const type.
func PossibleSharedTypeKindValues() []SharedTypeKind {
	return []SharedTypeKind{SharedTypeKindShared, SharedTypeKindUser}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeNone ...
	TypeNone Type = "None"
	// TypeUserAssigned ...
	TypeUserAssigned Type = "UserAssigned"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeNone, TypeUserAssigned}
}

// WebTestKind enumerates the values for web test kind.
type WebTestKind string

const (
	// WebTestKindMultistep ...
	WebTestKindMultistep WebTestKind = "multistep"
	// WebTestKindPing ...
	WebTestKindPing WebTestKind = "ping"
)

// PossibleWebTestKindValues returns an array of possible values for the WebTestKind const type.
func PossibleWebTestKindValues() []WebTestKind {
	return []WebTestKind{WebTestKindMultistep, WebTestKindPing}
}
