/*******************************************************************************
* Copyright 2018 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "jit_generator.hpp"
#include "common.hpp"

namespace mkldnn {
namespace impl {
namespace cpu {

jit_avx512_core_u8_copy_at_kern::jit_avx512_core_u8_copy_at_kern(): jit_generator(nullptr, GEMM_CODE_SIZE)
{

#ifndef _WIN32
#define M	rdi
#define N	rsi
#define A	rdx
#define LDA	rcx
#define ALPHA	r8
#define B	r9

#define I	rax
#define A1	r10
#define A2	r8
#define LDA3	r11

#else

#define M	rcx
#define N	rdx
#define A	r8
#define LDA	r9
#define ALPHA	rax
#define B	rdi

#define I	rax
#define A1	rsi
#define A2	r10
#define LDA3	r11

#define ARG_ALPHA	40+stacksize+rsp
#define ARG_B		48+stacksize+rsp

#endif

inLocalLabel();
{

Xbyak::Label l1014;
Xbyak::Label l1390;
Xbyak::Label l159c;
Xbyak::Label l173c;
Xbyak::Label l18e4;
Xbyak::Label l1a7c;
Xbyak::Label l1a8c;
Xbyak::Label l1a98;
Xbyak::Label l1ab4;
Xbyak::Label l1c64;
Xbyak::Label l1d74;
Xbyak::Label l1e50;
Xbyak::Label l1f2c;
Xbyak::Label l1ffc;
Xbyak::Label l20;
Xbyak::Label l200c;
Xbyak::Label l2018;
Xbyak::Label l2034;
Xbyak::Label l2110;
Xbyak::Label l21a0;
Xbyak::Label l2210;
Xbyak::Label l2284;
Xbyak::Label l22f0;
Xbyak::Label l2300;
Xbyak::Label l230c;
Xbyak::Label l2324;
Xbyak::Label l2398;
Xbyak::Label l23e8;
Xbyak::Label l242c;
Xbyak::Label l2474;
Xbyak::Label l24b4;
Xbyak::Label l24c4;
Xbyak::Label l24d0;
Xbyak::Label l24e8;
Xbyak::Label l2520;
Xbyak::Label l254c;
Xbyak::Label l2578;
Xbyak::Label l25a8;
Xbyak::Label l25c8;
Xbyak::Label l25d6;
Xbyak::Label l25e0;
Xbyak::Label l25f0;
Xbyak::Label l260c;
Xbyak::Label l262c;
Xbyak::Label l264c;
Xbyak::Label l2668;
Xbyak::Label l2680;
Xbyak::Label l2690;
Xbyak::Label l44;
Xbyak::Label l58c;
Xbyak::Label l8b0;
Xbyak::Label lb14;
Xbyak::Label ld84;
Xbyak::Label lfdc;
Xbyak::Label lfec;
Xbyak::Label lff8;

	preamble();
#ifdef _WIN32
	auto stacksize = get_size_of_abi_save_regs();
	mov(ALPHA, ptr[ARG_ALPHA]);
	mov(B, ptr[ARG_B]);
#endif

	mov(N, qword[N]);
	mov(M, qword[M]);
	mov(LDA, qword[LDA]);
	sub(A, -128);
	sub(B, -128);
	lea(LDA3, ptr[LDA+LDA*2]);
	cmp(N, 0x30);
	jl(lfec, T_NEAR);
	align(4);

L(l20);
	mov(A1, A);
	mov(I, LDA);
	shl(I, 0x5);
	lea(I, ptr[I+LDA*8]);
	lea(I, ptr[I+LDA*8]);
	add(A, I);
	mov(I, M);
	sar(I, 0x4);
	jle(l58c, T_NEAR);
	align(4);

L(l44);
	movdqu(xmm0, xword[A1-0x80]);
	movdqu(xmm1, xword[A1+LDA*1-0x80]);
	movdqu(xmm2, xword[A1+LDA*2-0x80]);
	movdqu(xmm3, xword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B+0x40], xmm1);
	movdqu(xword[B+0x100], xmm4);
	movdqu(xword[B+0x1c0], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B+0x50], xmm1);
	movdqu(xword[B+0x110], xmm4);
	movdqu(xword[B+0x1d0], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x60], xmm0);
	movdqu(xword[B+0x60], xmm1);
	movdqu(xword[B+0x120], xmm4);
	movdqu(xword[B+0x1e0], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x50], xmm0);
	movdqu(xword[B+0x70], xmm1);
	movdqu(xword[B+0x130], xmm4);
	movdqu(xword[B+0x1f0], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x40], xmm0);
	movdqu(xword[B+0x80], xmm1);
	movdqu(xword[B+0x140], xmm4);
	movdqu(xword[B+0x200], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x30], xmm0);
	movdqu(xword[B+0x90], xmm1);
	movdqu(xword[B+0x150], xmm4);
	movdqu(xword[B+0x210], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x20], xmm0);
	movdqu(xword[B+0xa0], xmm1);
	movdqu(xword[B+0x160], xmm4);
	movdqu(xword[B+0x220], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x10], xmm0);
	movdqu(xword[B+0xb0], xmm1);
	movdqu(xword[B+0x170], xmm4);
	movdqu(xword[B+0x230], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B], xmm0);
	movdqu(xword[B+0xc0], xmm1);
	movdqu(xword[B+0x180], xmm4);
	movdqu(xword[B+0x240], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B+0x10], xmm0);
	movdqu(xword[B+0xd0], xmm1);
	movdqu(xword[B+0x190], xmm4);
	movdqu(xword[B+0x250], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B+0x20], xmm0);
	movdqu(xword[B+0xe0], xmm1);
	movdqu(xword[B+0x1a0], xmm4);
	movdqu(xword[B+0x260], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B+0x30], xmm0);
	movdqu(xword[B+0xf0], xmm1);
	movdqu(xword[B+0x1b0], xmm4);
	movdqu(xword[B+0x270], xmm3);
	sub(A1, -16);
	sub(B, -768);
	dec(I);
	jg(l44, T_NEAR);
	align(4);

L(l58c);
	test(M, 0x8);
	jle(l8b0, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	movq(xmm1, qword[A1+LDA*1-0x80]);
	movq(xmm2, qword[A1+LDA*2-0x80]);
	movq(xmm3, qword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B+0x40], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B+0x50], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x60], xmm0);
	movdqu(xword[B+0x60], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x50], xmm0);
	movdqu(xword[B+0x70], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x40], xmm0);
	movdqu(xword[B+0x80], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x30], xmm0);
	movdqu(xword[B+0x90], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x20], xmm0);
	movdqu(xword[B+0xa0], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x10], xmm0);
	movdqu(xword[B+0xb0], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B], xmm0);
	movdqu(xword[B+0xc0], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B+0x10], xmm0);
	movdqu(xword[B+0xd0], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B+0x20], xmm0);
	movdqu(xword[B+0xe0], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B+0x30], xmm0);
	movdqu(xword[B+0xf0], xmm1);
	sub(A1, -8);
	sub(B, -384);
	align(4);

L(l8b0);
	test(M, 0x4);
	jle(lb14, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	movd(xmm1, dword[A1+LDA*1-0x80]);
	movd(xmm2, dword[A1+LDA*2-0x80]);
	movd(xmm3, dword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x60], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x50], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x40], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x30], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x20], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x10], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B+0x10], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B+0x20], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B+0x30], xmm0);
	sub(A1, -4);
	sub(B, -192);
	align(4);

L(lb14);
	test(M, 0x2);
	jle(ld84, T_NEAR);
	mov(ax, word[A1-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A1+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A1+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x7);
	movdqu(xword[B-0x80], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x70], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x60], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x50], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x40], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x30], xmm0);
	sub(A1, -2);
	sub(B, -96);
	align(4);

L(ld84);
	test(M, 0x1);
	jle(lfdc, T_NEAR);
	mov(al, byte[A1-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A1+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A1+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x7);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x8);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x9);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xa);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xb);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0xc);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0xd);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xe);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xf);
	movdqu(xword[B-0x80], xmm0);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x7);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x8);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x9);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xa);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xb);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0xc);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0xd);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xe);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xf);
	movdqu(xword[B-0x70], xmm0);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x7);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x8);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x9);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xa);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xb);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0xc);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0xd);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xe);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xf);
	movdqu(xword[B-0x60], xmm0);
	sub(B, -48);
	align(4);

L(lfdc);
	sub(N, 0x30);
	cmp(N, 0x30);
	jge(l20, T_NEAR);
	align(4);

L(lfec);
	cmp(N, 0x20);
	jl(l1a8c, T_NEAR);
	align(4);

L(lff8);
	mov(A1, A);
	mov(I, LDA);
	shl(I, 0x5);
	add(A, I);
	mov(I, M);
	sar(I, 0x4);
	jle(l1390, T_NEAR);
	align(4);

L(l1014);
	movdqu(xmm0, xword[A1-0x80]);
	movdqu(xmm1, xword[A1+LDA*1-0x80]);
	movdqu(xmm2, xword[A1+LDA*2-0x80]);
	movdqu(xmm3, xword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B], xmm1);
	movdqu(xword[B+0x80], xmm4);
	movdqu(xword[B+0x100], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B+0x10], xmm1);
	movdqu(xword[B+0x90], xmm4);
	movdqu(xword[B+0x110], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x60], xmm0);
	movdqu(xword[B+0x20], xmm1);
	movdqu(xword[B+0xa0], xmm4);
	movdqu(xword[B+0x120], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x50], xmm0);
	movdqu(xword[B+0x30], xmm1);
	movdqu(xword[B+0xb0], xmm4);
	movdqu(xword[B+0x130], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x40], xmm0);
	movdqu(xword[B+0x40], xmm1);
	movdqu(xword[B+0xc0], xmm4);
	movdqu(xword[B+0x140], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x30], xmm0);
	movdqu(xword[B+0x50], xmm1);
	movdqu(xword[B+0xd0], xmm4);
	movdqu(xword[B+0x150], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x20], xmm0);
	movdqu(xword[B+0x60], xmm1);
	movdqu(xword[B+0xe0], xmm4);
	movdqu(xword[B+0x160], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x10], xmm0);
	movdqu(xword[B+0x70], xmm1);
	movdqu(xword[B+0xf0], xmm4);
	movdqu(xword[B+0x170], xmm3);
	sub(A1, -16);
	sub(B, -512);
	dec(I);
	jg(l1014, T_NEAR);
	align(4);

L(l1390);
	test(M, 0x8);
	jle(l159c, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	movq(xmm1, qword[A1+LDA*1-0x80]);
	movq(xmm2, qword[A1+LDA*2-0x80]);
	movq(xmm3, qword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B+0x10], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x60], xmm0);
	movdqu(xword[B+0x20], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x50], xmm0);
	movdqu(xword[B+0x30], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x40], xmm0);
	movdqu(xword[B+0x40], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x30], xmm0);
	movdqu(xword[B+0x50], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x20], xmm0);
	movdqu(xword[B+0x60], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x10], xmm0);
	movdqu(xword[B+0x70], xmm1);
	sub(A1, -8);
	sub(B, -256);
	align(4);

L(l159c);
	test(M, 0x4);
	jle(l173c, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	movd(xmm1, dword[A1+LDA*1-0x80]);
	movd(xmm2, dword[A1+LDA*2-0x80]);
	movd(xmm3, dword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x60], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x50], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x40], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x30], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x20], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x10], xmm0);
	sub(A1, -4);
	sub(B, -128);
	align(4);

L(l173c);
	test(M, 0x2);
	jle(l18e4, T_NEAR);
	mov(ax, word[A1-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A1+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A1+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x7);
	movdqu(xword[B-0x80], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x70], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x60], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	lea(A2, ptr[A2+LDA*4]);
	movdqu(xword[B-0x50], xmm0);
	sub(A1, -2);
	sub(B, -64);
	align(4);

L(l18e4);
	test(M, 0x1);
	jle(l1a7c, T_NEAR);
	mov(al, byte[A1-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A1+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A1+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x7);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x8);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x9);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xa);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xb);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0xc);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0xd);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xe);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xf);
	movdqu(xword[B-0x80], xmm0);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x7);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x8);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x9);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xa);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xb);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0xc);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0xd);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xe);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xf);
	movdqu(xword[B-0x70], xmm0);
	sub(B, -32);
	align(4);

L(l1a7c);
	sub(N, 0x20);
	cmp(N, 0x20);
	jge(lff8, T_NEAR);
	align(4);

L(l1a8c);
	cmp(N, 0x10);
	jl(l200c, T_NEAR);
	align(4);

L(l1a98);
	mov(A1, A);
	mov(I, LDA);
	shl(I, 0x4);
	add(A, I);
	mov(I, M);
	sar(I, 0x4);
	jle(l1c64, T_NEAR);
	align(4);

L(l1ab4);
	movdqu(xmm0, xword[A1-0x80]);
	movdqu(xmm1, xword[A1+LDA*1-0x80]);
	movdqu(xmm2, xword[A1+LDA*2-0x80]);
	movdqu(xmm3, xword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x40], xmm1);
	movdqu(xword[B], xmm4);
	movdqu(xword[B+0x40], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B-0x30], xmm1);
	movdqu(xword[B+0x10], xmm4);
	movdqu(xword[B+0x50], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x60], xmm0);
	movdqu(xword[B-0x20], xmm1);
	movdqu(xword[B+0x20], xmm4);
	movdqu(xword[B+0x60], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x50], xmm0);
	movdqu(xword[B-0x10], xmm1);
	movdqu(xword[B+0x30], xmm4);
	movdqu(xword[B+0x70], xmm3);
	sub(A1, -16);
	sub(B, -256);
	dec(I);
	jg(l1ab4, T_NEAR);
	align(4);

L(l1c64);
	test(M, 0x8);
	jle(l1d74, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	movq(xmm1, qword[A1+LDA*1-0x80]);
	movq(xmm2, qword[A1+LDA*2-0x80]);
	movq(xmm3, qword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x40], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B-0x30], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x60], xmm0);
	movdqu(xword[B-0x20], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x50], xmm0);
	movdqu(xword[B-0x10], xmm1);
	sub(A1, -8);
	sub(B, -128);
	align(4);

L(l1d74);
	test(M, 0x4);
	jle(l1e50, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	movd(xmm1, dword[A1+LDA*1-0x80]);
	movd(xmm2, dword[A1+LDA*2-0x80]);
	movd(xmm3, dword[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x60], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x50], xmm0);
	sub(A1, -4);
	sub(B, -64);
	align(4);

L(l1e50);
	test(M, 0x2);
	jle(l1f2c, T_NEAR);
	mov(ax, word[A1-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A1+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A1+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x7);
	movdqu(xword[B-0x80], xmm0);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	pinsrw(xmm0, eax, 0x7);
	movdqu(xword[B-0x70], xmm0);
	sub(A1, -2);
	sub(B, -32);
	align(4);

L(l1f2c);
	test(M, 0x1);
	jle(l1ffc, T_NEAR);
	mov(al, byte[A1-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A1+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A1+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A1+LDA3*1-0x80]);
	lea(A2, ptr[A1+LDA*4]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0x7);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x8);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x9);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xa);
	mov(al, byte[A2+LDA3*1-0x80]);
	lea(A2, ptr[A2+LDA*4]);
	pinsrb(xmm0, eax, 0xb);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0xc);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0xd);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0xe);
	mov(al, byte[A2+LDA3*1-0x80]);
	pinsrb(xmm0, eax, 0xf);
	movdqu(xword[B-0x80], xmm0);
	sub(B, -16);
	align(4);

L(l1ffc);
	sub(N, 0x10);
	cmp(N, 0x10);
	jge(l1a98, T_NEAR);
	align(4);

L(l200c);
	cmp(N, 0x8);
	jl(l2300, T_NEAR);
	align(4);

L(l2018);
	mov(A1, A);
	lea(A2, ptr[A1+LDA*4]);
	lea(I, ptr[A1+LDA*8]);
	mov(A, I);
	mov(I, M);
	sar(I, 0x4);
	jle(l2110, T_NEAR);
	align(4);

L(l2034);
	movdqu(xmm0, xword[A1-0x80]);
	movdqu(xmm1, xword[A1+LDA*1-0x80]);
	movdqu(xmm2, xword[A1+LDA*2-0x80]);
	movdqu(xmm3, xword[A1+LDA3*1-0x80]);
	sub(A1, -16);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x60], xmm1);
	movdqu(xword[B-0x40], xmm4);
	movdqu(xword[B-0x20], xmm3);
	movdqu(xmm0, xword[A2-0x80]);
	movdqu(xmm1, xword[A2+LDA*1-0x80]);
	movdqu(xmm2, xword[A2+LDA*2-0x80]);
	movdqu(xmm3, xword[A2+LDA3*1-0x80]);
	sub(A2, -16);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B-0x50], xmm1);
	movdqu(xword[B-0x30], xmm4);
	movdqu(xword[B-0x10], xmm3);
	sub(B, -128);
	dec(I);
	jg(l2034, T_NEAR);
	align(4);

L(l2110);
	test(M, 0x8);
	jle(l21a0, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	movq(xmm1, qword[A1+LDA*1-0x80]);
	movq(xmm2, qword[A1+LDA*2-0x80]);
	movq(xmm3, qword[A1+LDA3*1-0x80]);
	sub(A1, -8);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x60], xmm1);
	movq(xmm0, qword[A2-0x80]);
	movq(xmm1, qword[A2+LDA*1-0x80]);
	movq(xmm2, qword[A2+LDA*2-0x80]);
	movq(xmm3, qword[A2+LDA3*1-0x80]);
	sub(A2, -8);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x70], xmm0);
	movdqu(xword[B-0x50], xmm1);
	sub(B, -64);
	align(4);

L(l21a0);
	test(M, 0x4);
	jle(l2210, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	movd(xmm1, dword[A1+LDA*1-0x80]);
	movd(xmm2, dword[A1+LDA*2-0x80]);
	movd(xmm3, dword[A1+LDA3*1-0x80]);
	sub(A1, -4);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movd(xmm0, dword[A2-0x80]);
	movd(xmm1, dword[A2+LDA*1-0x80]);
	movd(xmm2, dword[A2+LDA*2-0x80]);
	movd(xmm3, dword[A2+LDA3*1-0x80]);
	sub(A2, -4);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x70], xmm0);
	sub(B, -32);
	align(4);

L(l2210);
	test(M, 0x2);
	jle(l2284, T_NEAR);
	mov(ax, word[A1-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A1+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A1+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A1+LDA3*1-0x80]);
	sub(A1, -2);
	pinsrw(xmm0, eax, 0x3);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x4);
	mov(ax, word[A2+LDA*1-0x80]);
	pinsrw(xmm0, eax, 0x5);
	mov(ax, word[A2+LDA*2-0x80]);
	pinsrw(xmm0, eax, 0x6);
	mov(ax, word[A2+LDA3*1-0x80]);
	sub(A2, -2);
	pinsrw(xmm0, eax, 0x7);
	movdqu(xword[B-0x80], xmm0);
	sub(B, -16);
	align(4);

L(l2284);
	test(M, 0x1);
	jle(l22f0, T_NEAR);
	mov(al, byte[A1-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A1+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A1+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A1+LDA3*1-0x80]);
	pinsrb(xmm0, eax, 0x3);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x4);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x5);
	mov(al, byte[A2+LDA*2-0x80]);
	pinsrb(xmm0, eax, 0x6);
	mov(al, byte[A2+LDA3*1-0x80]);
	pinsrb(xmm0, eax, 0x7);
	movq(qword[B-0x80], xmm0);
	sub(B, -8);
	align(4);

L(l22f0);
	sub(N, 0x8);
	cmp(N, 0x8);
	jge(l2018, T_NEAR);
	align(4);

L(l2300);
	cmp(N, 0x4);
	jl(l24c4, T_NEAR);
	align(4);

L(l230c);
	mov(A1, A);
	lea(A2, ptr[A1+LDA*2]);
	lea(I, ptr[A1+LDA*4]);
	mov(A, I);
	mov(I, M);
	sar(I, 0x4);
	jle(l2398, T_NEAR);
	align(4);

L(l2324);
	movdqu(xmm0, xword[A1-0x80]);
	movdqu(xmm1, xword[A1+LDA*1-0x80]);
	sub(A1, -16);
	movdqu(xmm2, xword[A2-0x80]);
	movdqu(xmm3, xword[A2+LDA*1-0x80]);
	sub(A2, -16);
	movdqa(xmm4, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm4, xmm1);
	movdqa(xmm5, xmm2);
	punpckldq(xmm2, xmm3);
	punpckhdq(xmm5, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqa(xmm3, xmm4);
	punpcklqdq(xmm4, xmm5);
	punpckhqdq(xmm3, xmm5);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x70], xmm1);
	movdqu(xword[B-0x60], xmm4);
	movdqu(xword[B-0x50], xmm3);
	sub(B, -64);
	dec(I);
	jg(l2324, T_NEAR);
	align(4);

L(l2398);
	test(M, 0x8);
	jle(l23e8, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	movq(xmm1, qword[A1+LDA*1-0x80]);
	sub(A1, -8);
	movq(xmm2, qword[A2-0x80]);
	movq(xmm3, qword[A2+LDA*1-0x80]);
	sub(A2, -8);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	movdqa(xmm1, xmm0);
	punpcklqdq(xmm0, xmm2);
	punpckhqdq(xmm1, xmm2);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x70], xmm1);
	sub(B, -32);
	align(4);

L(l23e8);
	test(M, 0x4);
	jle(l242c, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	movd(xmm1, dword[A1+LDA*1-0x80]);
	sub(A1, -4);
	movd(xmm2, dword[A2-0x80]);
	movd(xmm3, dword[A2+LDA*1-0x80]);
	sub(A2, -4);
	punpckldq(xmm0, xmm1);
	punpckldq(xmm2, xmm3);
	punpcklqdq(xmm0, xmm2);
	movdqu(xword[B-0x80], xmm0);
	sub(B, -16);
	align(4);

L(l242c);
	test(M, 0x2);
	jle(l2474, T_NEAR);
	mov(ax, word[A1-0x80]);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A1+LDA*1-0x80]);
	sub(A1, -2);
	pinsrw(xmm0, eax, 0x1);
	mov(ax, word[A2-0x80]);
	pinsrw(xmm0, eax, 0x2);
	mov(ax, word[A2+LDA*1-0x80]);
	sub(A2, -2);
	pinsrw(xmm0, eax, 0x3);
	movq(qword[B-0x80], xmm0);
	sub(B, -8);
	align(4);

L(l2474);
	test(M, 0x1);
	jle(l24b4, T_NEAR);
	mov(al, byte[A1-0x80]);
	pinsrb(xmm0, eax, 0x0);
	mov(al, byte[A1+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x1);
	mov(al, byte[A2-0x80]);
	pinsrb(xmm0, eax, 0x2);
	mov(al, byte[A2+LDA*1-0x80]);
	pinsrb(xmm0, eax, 0x3);
	movd(dword[B-0x80], xmm0);
	sub(B, -4);
	align(4);

L(l24b4);
	sub(N, 0x4);
	cmp(N, 0x4);
	jge(l230c, T_NEAR);
	align(4);

L(l24c4);
	cmp(N, 0x2);
	jl(l25d6, T_NEAR);
	align(4);

L(l24d0);
	mov(A1, A);
	lea(A2, ptr[A1+LDA*1]);
	lea(I, ptr[A1+LDA*2]);
	mov(A, I);
	mov(I, M);
	sar(I, 0x4);
	jle(l2520, T_NEAR);
	align(4);

L(l24e8);
	movdqu(xmm0, xword[A1-0x80]);
	sub(A1, -16);
	movdqu(xmm1, xword[A2-0x80]);
	sub(A2, -16);
	movdqa(xmm2, xmm0);
	punpckldq(xmm0, xmm1);
	punpckhdq(xmm2, xmm1);
	movdqu(xword[B-0x80], xmm0);
	movdqu(xword[B-0x70], xmm2);
	sub(B, -32);
	dec(I);
	jg(l24e8, T_NEAR);
	align(4);

L(l2520);
	test(M, 0x8);
	jle(l254c, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	sub(A1, -8);
	movq(xmm1, qword[A2-0x80]);
	sub(A2, -8);
	punpckldq(xmm0, xmm1);
	movdqu(xword[B-0x80], xmm0);
	sub(B, -16);
	align(4);

L(l254c);
	test(M, 0x4);
	jle(l2578, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	sub(A1, -4);
	movd(xmm1, dword[A2-0x80]);
	sub(A2, -4);
	punpckldq(xmm0, xmm1);
	movq(qword[B-0x80], xmm0);
	sub(B, -8);
	align(4);

L(l2578);
	test(M, 0x2);
	jle(l25a8, T_NEAR);
	mov(ax, word[A1-0x80]);
	sub(A1, -2);
	pinsrw(xmm0, eax, 0x0);
	mov(ax, word[A2-0x80]);
	sub(A2, -2);
	pinsrw(xmm0, eax, 0x1);
	movd(dword[B-0x80], xmm0);
	sub(B, -4);
	align(4);

L(l25a8);
	test(M, 0x1);
	jle(l25c8, T_NEAR);
	mov(al, byte[A1-0x80]);
	mov(byte[B-0x80], al);
	mov(al, byte[A2-0x80]);
	mov(byte[B-0x7f], al);
	sub(B, -2);
	align(4);

L(l25c8);
	sub(N, 0x2);
	cmp(N, 0x2);
	jge(l24d0, T_NEAR);
	align(4);

L(l25d6);
	cmp(N, 0x1);
	jl(l2690, T_NEAR);
	align(4);

L(l25e0);
	mov(A1, A);
	add(A, LDA);
	mov(I, M);
	sar(I, 0x4);
	jle(l260c, T_NEAR);
	align(4);

L(l25f0);
	movdqu(xmm0, xword[A1-0x80]);
	sub(A1, -16);
	movdqu(xword[B-0x80], xmm0);
	sub(B, -16);
	dec(I);
	jg(l25f0, T_NEAR);
	align(4);

L(l260c);
	test(M, 0x8);
	jle(l262c, T_NEAR);
	movq(xmm0, qword[A1-0x80]);
	sub(A1, -8);
	movq(qword[B-0x80], xmm0);
	sub(B, -8);
	align(4);

L(l262c);
	test(M, 0x4);
	jle(l264c, T_NEAR);
	movd(xmm0, dword[A1-0x80]);
	sub(A1, -4);
	movd(dword[B-0x80], xmm0);
	sub(B, -4);
	align(4);

L(l264c);
	test(M, 0x2);
	jle(l2668, T_NEAR);
	mov(ax, word[A1-0x80]);
	mov(word[B-0x80], ax);
	sub(A1, -2);
	sub(B, -2);
	align(4);

L(l2668);
	test(M, 0x1);
	jle(l2680, T_NEAR);
	mov(al, byte[A1-0x80]);
	mov(byte[B-0x80], al);
	sub(B, -1);
	align(4);

L(l2680);
	sub(N, 0x1);
	cmp(N, 0x1);
	jge(l25e0, T_NEAR);
	align(4);

L(l2690);

	postamble();
}
outLocalLabel();

#undef M
#undef N
#undef A
#undef LDA
#undef ALPHA
#undef B
#undef I
#undef A1
#undef A2
#undef LDA3
#ifdef _WIN32
#undef ARG_ALPHA
#undef ARG_B
#endif
}

}
}
}
