/*
 * Copyright 2022-2024 Andrey Kutejko <andy128k@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * For more details see the file COPYING.
 */

use crate::svg_paintable::SvgPaintable;
use gtk::{gdk, gdk_pixbuf, prelude::*};
use std::error::Error;
use std::path::Path;

pub fn image_from_file(filename: &Path) -> Result<gdk::Paintable, Box<dyn Error>> {
    rsvg::Loader::new()
        .read_path(filename)
        .map(|handle| SvgPaintable::new(handle).upcast())
        .or_else(|_svg_error| {
            let pixbuf = gdk_pixbuf::Pixbuf::from_file(filename)?;
            Ok(gdk::Texture::for_pixbuf(&pixbuf).upcast())
        })
}
