// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
)

// Associate your S3 Access Grants instance with an Amazon Web Services IAM
// Identity Center instance. Use this action if you want to create access grants
// for users or groups from your corporate identity directory. First, you must add
// your corporate identity directory to Amazon Web Services IAM Identity Center.
// Then, you can associate this IAM Identity Center instance with your S3 Access
// Grants instance.
//
// Permissions You must have the s3:AssociateAccessGrantsIdentityCenter permission
// to use this operation.
//
// Additional Permissions You must also have the following permissions:
// sso:CreateApplication , sso:PutApplicationGrant , and
// sso:PutApplicationAuthenticationMethod .
func (c *Client) AssociateAccessGrantsIdentityCenter(ctx context.Context, params *AssociateAccessGrantsIdentityCenterInput, optFns ...func(*Options)) (*AssociateAccessGrantsIdentityCenterOutput, error) {
	if params == nil {
		params = &AssociateAccessGrantsIdentityCenterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateAccessGrantsIdentityCenter", params, optFns, c.addOperationAssociateAccessGrantsIdentityCenterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateAccessGrantsIdentityCenterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateAccessGrantsIdentityCenterInput struct {

	// The ID of the Amazon Web Services account that is making this request.
	//
	// This member is required.
	AccountId *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center
	// instance that you are associating with your S3 Access Grants instance. An IAM
	// Identity Center instance is your corporate identity directory that you added to
	// the IAM Identity Center. You can use the [ListInstances]API operation to retrieve a list of
	// your Identity Center instances and their ARNs.
	//
	// [ListInstances]: https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html
	//
	// This member is required.
	IdentityCenterArn *string

	noSmithyDocumentSerde
}

func (in *AssociateAccessGrantsIdentityCenterInput) bindEndpointParams(p *EndpointParameters) {
	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type AssociateAccessGrantsIdentityCenterOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateAccessGrantsIdentityCenterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpAssociateAccessGrantsIdentityCenter{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpAssociateAccessGrantsIdentityCenter{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateAccessGrantsIdentityCenter"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddContentChecksumMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opAssociateAccessGrantsIdentityCenterMiddleware(stack); err != nil {
		return err
	}
	if err = addOpAssociateAccessGrantsIdentityCenterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateAccessGrantsIdentityCenter(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addAssociateAccessGrantsIdentityCenterUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opAssociateAccessGrantsIdentityCenterMiddleware struct {
}

func (*endpointPrefix_opAssociateAccessGrantsIdentityCenterMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opAssociateAccessGrantsIdentityCenterMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*AssociateAccessGrantsIdentityCenterInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opAssociateAccessGrantsIdentityCenterMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opAssociateAccessGrantsIdentityCenterMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opAssociateAccessGrantsIdentityCenter(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateAccessGrantsIdentityCenter",
	}
}

func copyAssociateAccessGrantsIdentityCenterInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*AssociateAccessGrantsIdentityCenterInput)
	if !ok {
		return nil, fmt.Errorf("expect *AssociateAccessGrantsIdentityCenterInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *AssociateAccessGrantsIdentityCenterInput) copy() interface{} {
	v := *in
	return &v
}
func backFillAssociateAccessGrantsIdentityCenterAccountID(input interface{}, v string) error {
	in := input.(*AssociateAccessGrantsIdentityCenterInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addAssociateAccessGrantsIdentityCenterUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyAssociateAccessGrantsIdentityCenterInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
