// Code generated by smithy-go-codegen DO NOT EDIT.

package firehose

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/firehose/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables server-side encryption (SSE) for the delivery stream.
//
// This operation is asynchronous. It returns immediately. When you invoke it,
// Firehose first sets the encryption status of the stream to ENABLING , and then
// to ENABLED . The encryption status of a delivery stream is the Status property
// in DeliveryStreamEncryptionConfiguration. If the operation fails, the encryption status changes to ENABLING_FAILED .
// You can continue to read and write data to your delivery stream while the
// encryption status is ENABLING , but the data is not encrypted. It can take up to
// 5 seconds after the encryption status changes to ENABLED before all records
// written to the delivery stream are encrypted. To find out whether a record or a
// batch of records was encrypted, check the response elements PutRecordOutput$Encryptedand PutRecordBatchOutput$Encrypted, respectively.
//
// To check the encryption status of a delivery stream, use DescribeDeliveryStream.
//
// Even if encryption is currently enabled for a delivery stream, you can still
// invoke this operation on it to change the ARN of the CMK or both its type and
// ARN. If you invoke this method to change the CMK, and the old CMK is of type
// CUSTOMER_MANAGED_CMK , Firehose schedules the grant it had on the old CMK for
// retirement. If the new CMK is of type CUSTOMER_MANAGED_CMK , Firehose creates a
// grant that enables it to use the new CMK to encrypt and decrypt data and to
// manage the grant.
//
// For the KMS grant creation to be successful, Firehose APIs
// StartDeliveryStreamEncryption and CreateDeliveryStream should not be called
// with session credentials that are more than 6 hours old.
//
// If a delivery stream already has encryption enabled and then you invoke this
// operation to change the ARN of the CMK or both its type and ARN and you get
// ENABLING_FAILED , this only means that the attempt to change the CMK failed. In
// this case, encryption remains enabled with the old CMK.
//
// If the encryption status of your delivery stream is ENABLING_FAILED , you can
// invoke this operation again with a valid CMK. The CMK must be enabled and the
// key policy mustn't explicitly deny the permission for Firehose to invoke KMS
// encrypt and decrypt operations.
//
// You can enable SSE for a delivery stream only if it's a delivery stream that
// uses DirectPut as its source.
//
// The StartDeliveryStreamEncryption and StopDeliveryStreamEncryption operations
// have a combined limit of 25 calls per delivery stream per 24 hours. For example,
// you reach the limit if you call StartDeliveryStreamEncryption 13 times and
// StopDeliveryStreamEncryption 12 times for the same delivery stream in a 24-hour
// period.
func (c *Client) StartDeliveryStreamEncryption(ctx context.Context, params *StartDeliveryStreamEncryptionInput, optFns ...func(*Options)) (*StartDeliveryStreamEncryptionOutput, error) {
	if params == nil {
		params = &StartDeliveryStreamEncryptionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDeliveryStreamEncryption", params, optFns, c.addOperationStartDeliveryStreamEncryptionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDeliveryStreamEncryptionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDeliveryStreamEncryptionInput struct {

	// The name of the delivery stream for which you want to enable server-side
	// encryption (SSE).
	//
	// This member is required.
	DeliveryStreamName *string

	// Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed
	// for Server-Side Encryption (SSE).
	DeliveryStreamEncryptionConfigurationInput *types.DeliveryStreamEncryptionConfigurationInput

	noSmithyDocumentSerde
}

type StartDeliveryStreamEncryptionOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDeliveryStreamEncryptionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartDeliveryStreamEncryption{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartDeliveryStreamEncryption{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDeliveryStreamEncryption"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartDeliveryStreamEncryptionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDeliveryStreamEncryption(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDeliveryStreamEncryption(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDeliveryStreamEncryption",
	}
}
